"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _page_loader = require("../../../common/components/page_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Loader = ({
  loading,
  loadingTitle,
  error,
  errorTitle,
  errorBody,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !loading && !error ? children : null, error && !loading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, errorTitle),
    body: /*#__PURE__*/_react.default.createElement("p", null, errorBody)
  })) : null, loading ? /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", null, loadingTitle)
  }) : null);
};
exports.Loader = Loader;