"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchField = SearchField;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchField() {
  const {
    query
  } = (0, _hooks.useGetUrlParams)();
  const [_, updateUrlParams] = (0, _hooks.useUrlParams)();
  const [search, setSearch] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => {
    if (search !== query) {
      updateUrlParams({
        query: search
      });
    }
  }, 300, [search]);

  // Hydrate search input
  const hasInputChangedRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (query !== search && !hasInputChangedRef.current) {
      setSearch(query);
    }

    // Run only to sync url with input
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [query]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    css: {
      minWidth: 230
    },
    fullWidth: true,
    placeholder: PLACEHOLDER_TEXT,
    value: search,
    onChange: e => {
      var _e$target$value;
      hasInputChangedRef.current = true;
      setSearch((_e$target$value = e.target.value) !== null && _e$target$value !== void 0 ? _e$target$value : '');
    },
    isClearable: true,
    "aria-label": PLACEHOLDER_TEXT,
    "data-test-subj": "syntheticsOverviewSearchInput"
  });
}
const PLACEHOLDER_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.placeholder', {
  defaultMessage: `Search by name, URL, host, tag, project or location`
});