"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorAddEditBreadcrumbs = exports.EDIT_MONITOR_CRUMB = exports.ADD_MONITOR_CRUMB = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _constants = require("../../../../../common/constants");
var _plugin = require("../../../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorAddEditBreadcrumbs = isEdit => {
  var _kibana$services$appl, _kibana$services$appl2;
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const config = isEdit ? {
    text: EDIT_MONITOR_CRUMB,
    href: `${appPath}/${_constants.MONITOR_EDIT_ROUTE}`
  } : {
    text: ADD_MONITOR_CRUMB,
    href: `${appPath}/${_constants.MONITOR_ADD_ROUTE}`
  };
  (0, _use_breadcrumbs.useBreadcrumbs)([config]);
};
exports.useMonitorAddEditBreadcrumbs = useMonitorAddEditBreadcrumbs;
const ADD_MONITOR_CRUMB = exports.ADD_MONITOR_CRUMB = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addMonitorCrumb', {
  defaultMessage: 'Create monitor'
});
const EDIT_MONITOR_CRUMB = exports.EDIT_MONITOR_CRUMB = _i18n.i18n.translate('xpack.synthetics.monitorManagement.editMonitorCrumb', {
  defaultMessage: 'Edit monitor'
});