"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityStreamsAppPageTemplate = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createObservabilityStreamsAppPageTemplate = ({
  observabilityShared,
  navigation
}) => ({
  children
}) => {
  const {
    PageTemplate
  } = observabilityShared.navigation;
  const isSolutionNavEnabled = (0, _useObservable.default)(navigation.isSolutionNavEnabled$);
  return /*#__PURE__*/_react2.default.createElement(PageTemplate, {
    pageSectionProps: {
      color: 'subdued',
      css: (0, _react.css)`
            max-height: calc(
              100vh - var(--euiFixedHeadersOffset, 0)
                ${isSolutionNavEnabled ? `- var(--kbnProjectHeaderAppActionMenuHeight, 48px)` : ''}
            );
            overflow: auto;
            padding-inline: 0px;
          `,
      contentProps: {
        css: (0, _react.css)`
              padding-block: 0px;
              display: flex;
              flex-direction: column;
              height: 100%;
            `
      }
    }
  }, children);
};
exports.createObservabilityStreamsAppPageTemplate = createObservabilityStreamsAppPageTemplate;