"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsChartTooltip = StreamsChartTooltip;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamsChartTooltip({
  header,
  label,
  color
}) {
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    gridTemplateColumns: "none",
    className: (0, _css.css)`
          padding: ${theme.size.xs};
        `
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableBody, null, header ? /*#__PURE__*/_react.default.createElement(_charts.TooltipTableHeader, {
    className: (0, _css.css)`
                padding: 0px ${theme.size.s};
              `
  }, header) : null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, {
    color: color
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, null, label)))));
}