"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddProcessorPanel = AddProcessorPanel;
exports.EditProcessorPanel = EditProcessorPanel;
exports.discardChangesPromptOptions = exports.deleteProcessorPromptOptions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@xstate5/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _react3 = require("@emotion/react");
var _use_discard_confirm = require("../../../../hooks/use_discard_confirm");
var _dissect = require("./dissect");
var _grok = require("./grok");
var _processor_type_selector = require("./processor_type_selector");
var _utils = require("../utils");
var _processor_metrics = require("./processor_metrics");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _date = require("./date");
var _fields = require("./config_driven/components/fields");
var _selectors = require("../state_management/simulation_state_machine/selectors");
var _manual_ingest_pipeline = require("./manual_ingest_pipeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddProcessorPanel() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    addProcessor
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const processorRef = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.processorsRefs.find(p => p.getSnapshot().matches('draft')));
  const processorMetrics = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula;
    return processorRef && ((_state$context$simula = state.context.simulation) === null || _state$context$simula === void 0 ? void 0 : _state$context$simula.processors_metrics[processorRef.id]);
  });
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.grokCollection);
  const isOpen = Boolean(processorRef);
  const defaultValuesGetter = (0, _react2.useCallback)(() => {
    var _getEnrichmentState$c;
    return (0, _utils.getDefaultFormStateByType)('grok', (0, _selectors.selectPreviewDocuments)((_getEnrichmentState$c = getEnrichmentState().context.simulatorRef) === null || _getEnrichmentState$c === void 0 ? void 0 : _getEnrichmentState$c.getSnapshot().context), {
      grokCollection
    });
  }, [getEnrichmentState, grokCollection]);
  const initialDefaultValues = (0, _react2.useMemo)(() => defaultValuesGetter(), [defaultValuesGetter]);
  const methods = (0, _reactHookForm.useForm)({
    // cast necessary because DeepPartial does not work with `unknown`
    defaultValues: initialDefaultValues,
    mode: 'onChange'
  });
  const type = (0, _reactHookForm.useWatch)({
    control: methods.control,
    name: 'type'
  });
  (0, _react2.useEffect)(() => {
    if (!processorRef) {
      methods.reset(defaultValuesGetter());
    }
  }, [defaultValuesGetter, methods, processorRef]);
  (0, _react2.useEffect)(() => {
    if (processorRef) {
      const {
        unsubscribe
      } = methods.watch(value => {
        const {
          processorDefinition,
          processorResources
        } = (0, _utils.convertFormStateToProcessor)(value);
        processorRef.send({
          type: 'processor.change',
          processor: processorDefinition,
          resources: processorResources
        });
      });
      return () => unsubscribe();
    }
  }, [methods, processorRef]);
  const handleCancel = (0, _use_discard_confirm.useDiscardConfirm)(() => processorRef === null || processorRef === void 0 ? void 0 : processorRef.send({
    type: 'processor.cancel'
  }), discardChangesPromptOptions);
  const handleSubmit = async () => {
    processorRef === null || processorRef === void 0 ? void 0 : processorRef.send({
      type: 'processor.stage'
    });
  };
  const handleOpen = () => {
    const defaultValues = defaultValuesGetter();
    methods.reset(defaultValues);
    const draftProcessor = createDraftProcessorFromForm(defaultValues);
    addProcessor(draftProcessor);
  };
  if (!isOpen) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      css: (0, _react3.css)`
          border: ${euiTheme.border.thin};
          box-shadow: none !important; // override default EuiPanel shadow on hover
          transform: none !important; // override default EuiPanel transform on hover
        `,
      onClick: handleOpen,
      type: "button",
      paddingSize: "m"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      color: "transparent",
      paddingSize: "xs"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      alignItems: "center"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "plus"
    }), _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.addProcessorAction', {
      defaultMessage: 'Add a processor'
    }))));
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: isOpen ? 'subdued' : undefined,
    hasBorder: true,
    css: (0, _react3.css)`
        border: ${euiTheme.border.thin};
        padding: ${euiTheme.size.m};
      `,
    type: "button"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: "add-processor-accordion",
    arrowDisplay: "none",
    buttonContent: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.addingProcessor', {
      defaultMessage: 'Adding processor'
    }),
    forceState: "open",
    extraAction: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "streamsAppAddProcessorPanelCancelButton",
      onClick: handleCancel,
      size: "s"
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.cancel', {
      defaultMessage: 'Cancel'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "streamsAppAddProcessorPanelAddProcessorButton",
      size: "s",
      fill: true,
      onClick: methods.handleSubmit(handleSubmit),
      disabled: !methods.formState.isValid && methods.formState.isSubmitted
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.confirmAddProcessor', {
      defaultMessage: 'Add processor'
    })))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react2.default.createElement(ProcessorMetricsHeader, {
    metrics: processorMetrics
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: methods.handleSubmit(handleSubmit)
  }, /*#__PURE__*/_react2.default.createElement(_processor_type_selector.ProcessorTypeSelector, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), type === 'date' && /*#__PURE__*/_react2.default.createElement(_date.DateProcessorForm, null), type === 'dissect' && /*#__PURE__*/_react2.default.createElement(_dissect.DissectProcessorForm, null), type === 'grok' && /*#__PURE__*/_react2.default.createElement(_grok.GrokProcessorForm, null), type === 'manual_ingest_pipeline' && /*#__PURE__*/_react2.default.createElement(_manual_ingest_pipeline.ManualIngestPipelineProcessorForm, null), !_utils.SPECIALISED_TYPES.includes(type) && /*#__PURE__*/_react2.default.createElement(_fields.ConfigDrivenProcessorFields, {
    type: type
  })), processorMetrics && !(0, _lodash.isEmpty)(processorMetrics.errors) && /*#__PURE__*/_react2.default.createElement(_processor_metrics.ProcessorErrors, {
    metrics: processorMetrics
  }))));
}
const createDraftProcessorFromForm = formState => {
  const {
    processorDefinition
  } = (0, _utils.convertFormStateToProcessor)(formState);
  return {
    id: 'draft',
    type: formState.type,
    ...processorDefinition
  };
};
function EditProcessorPanel({
  dragHandleProps,
  processorRef,
  processorMetrics
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const state = (0, _react.useSelector)(processorRef, s => s);
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const canEdit = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(s => s.context.definition.privileges.simulate);
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(_state => _state.context.grokCollection);
  const previousProcessor = state.context.previousProcessor;
  const processor = state.context.processor;
  const processorDescription = getProcessorDescription(processor);
  const isOpen = state.matches({
    configured: 'edit'
  });
  const isNew = state.context.isNew;
  const isUnsaved = isNew || state.context.isUpdated;
  const defaultValues = (0, _react2.useMemo)(() => {
    var _getEnrichmentState$c2;
    return (0, _utils.getFormStateFrom)((0, _selectors.selectPreviewDocuments)((_getEnrichmentState$c2 = getEnrichmentState().context.simulatorRef) === null || _getEnrichmentState$c2 === void 0 ? void 0 : _getEnrichmentState$c2.getSnapshot().context), {
      grokCollection
    }, processor);
  }, [getEnrichmentState, grokCollection, processor]);
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: defaultValues,
    mode: 'onChange'
  });
  const type = (0, _reactHookForm.useWatch)({
    control: methods.control,
    name: 'type'
  });
  (0, _react2.useEffect)(() => {
    const {
      unsubscribe
    } = methods.watch(value => {
      const {
        processorDefinition,
        processorResources
      } = (0, _utils.convertFormStateToProcessor)(value);
      processorRef.send({
        type: 'processor.change',
        processor: processorDefinition,
        resources: processorResources
      });
    });
    return () => unsubscribe();
  }, [methods, processorRef]);
  (0, _react2.useEffect)(() => {
    const subscription = processorRef.on('processor.changesDiscarded', () => {
      var _getEnrichmentState$c3;
      methods.reset((0, _utils.getFormStateFrom)((0, _selectors.selectPreviewDocuments)((_getEnrichmentState$c3 = getEnrichmentState().context.simulatorRef) === null || _getEnrichmentState$c3 === void 0 ? void 0 : _getEnrichmentState$c3.getSnapshot().context), {
        grokCollection
      }, previousProcessor));
    });
    return () => subscription.unsubscribe();
  }, [getEnrichmentState, grokCollection, methods, previousProcessor, processorRef]);
  const handleCancel = (0, _use_discard_confirm.useDiscardConfirm)(() => processorRef === null || processorRef === void 0 ? void 0 : processorRef.send({
    type: 'processor.cancel'
  }), discardChangesPromptOptions);
  const handleProcessorDelete = (0, _use_discard_confirm.useDiscardConfirm)(() => processorRef === null || processorRef === void 0 ? void 0 : processorRef.send({
    type: 'processor.delete'
  }), deleteProcessorPromptOptions);
  const handleSubmit = () => {
    processorRef.send({
      type: 'processor.update'
    });
  };
  const handleOpen = () => {
    processorRef.send({
      type: 'processor.edit'
    });
  };
  const buttonContent = isOpen ? /*#__PURE__*/_react2.default.createElement("strong", null, processor.type.toUpperCase()) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    hasShadow: false,
    color: "transparent",
    paddingSize: "xs"
  }, dragHandleProps), /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "grab"
  })), /*#__PURE__*/_react2.default.createElement("strong", null, processor.type.toUpperCase()), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    component: "span",
    size: "s",
    color: "subdued",
    className: "eui-textTruncate"
  }, processorDescription));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    color: isNew ? 'subdued' : undefined,
    css: (0, _react3.css)`
        border: ${euiTheme.border.thin};
        padding: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: "edit-processor-accordion",
    arrowProps: {
      css: {
        display: 'none'
      }
    },
    buttonContent: buttonContent,
    buttonContentClassName: "eui-textTruncate",
    buttonElement: "div",
    buttonProps: {
      /* Allow text ellipsis in flex child nodes */
      css: (0, _react3.css)`
            min-width: 0;
            &:is(:hover, :focus) {
              cursor: grab;
              text-decoration: none;
            }
          `
    },
    forceState: isOpen ? 'open' : 'closed',
    extraAction: isOpen ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "streamsAppEditProcessorPanelCancelButton",
      onClick: handleCancel,
      size: "s"
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.cancel', {
      defaultMessage: 'Cancel'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "streamsAppEditProcessorPanelUpdateProcessorButton",
      size: "s",
      fill: true,
      onClick: methods.handleSubmit(handleSubmit),
      disabled: !methods.formState.isValid || !state.can({
        type: 'processor.update'
      })
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.confirmEditProcessor', {
      defaultMessage: 'Update processor'
    }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, processorMetrics && /*#__PURE__*/_react2.default.createElement(_processor_metrics.ProcessorMetricBadges, processorMetrics), isUnsaved && /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorPanel.unsavedBadge', {
      defaultMessage: 'Unsaved'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "streamsAppEditProcessorPanelButton",
      onClick: handleOpen,
      iconType: "pencil",
      disabled: !canEdit,
      color: "text",
      size: "xs",
      "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.editProcessorAction', {
        defaultMessage: 'Edit {type} processor',
        values: {
          type: processor.type
        }
      })
    }))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react2.default.createElement(ProcessorMetricsHeader, {
    metrics: processorMetrics
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: methods.handleSubmit(handleSubmit)
  }, /*#__PURE__*/_react2.default.createElement(_processor_type_selector.ProcessorTypeSelector, {
    disabled: true
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), type === 'date' && /*#__PURE__*/_react2.default.createElement(_date.DateProcessorForm, null), type === 'grok' && /*#__PURE__*/_react2.default.createElement(_grok.GrokProcessorForm, null), type === 'dissect' && /*#__PURE__*/_react2.default.createElement(_dissect.DissectProcessorForm, null), type === 'manual_ingest_pipeline' && /*#__PURE__*/_react2.default.createElement(_manual_ingest_pipeline.ManualIngestPipelineProcessorForm, null), !_utils.SPECIALISED_TYPES.includes(type) && /*#__PURE__*/_react2.default.createElement(_fields.ConfigDrivenProcessorFields, {
    type: type
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppEditProcessorPanelButton",
    color: "danger",
    onClick: handleProcessorDelete
  }, deleteProcessorLabel), processorMetrics && !(0, _lodash.isEmpty)(processorMetrics.errors) && /*#__PURE__*/_react2.default.createElement(_processor_metrics.ProcessorErrors, {
    metrics: processorMetrics
  }))));
}
const ProcessorMetricsHeader = ({
  metrics
}) => {
  if (!metrics) return null;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_processor_metrics.ProcessorMetricBadges, metrics), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const deleteProcessorLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.deleteProcessorLabel', {
  defaultMessage: 'Delete processor'
});
const getProcessorDescription = processor => {
  if ((0, _utils.isGrokProcessor)(processor)) {
    return processor.grok.patterns.join(' • ');
  } else if ((0, _utils.isDissectProcessor)(processor)) {
    return processor.dissect.pattern;
  } else if ((0, _utils.isDateProcessor)(processor)) {
    return `${processor.date.field} • ${processor.date.formats.join(' - ')}`;
  }
  return '';
};
const discardChangesPromptOptions = exports.discardChangesPromptOptions = {
  message: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.message', {
    defaultMessage: 'Are you sure you want to discard your changes?'
  }),
  title: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.title', {
    defaultMessage: 'Discard changes?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.confirmButtonText', {
    defaultMessage: 'Discard'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.cancelButtonText', {
    defaultMessage: 'Keep editing'
  })
};
const deleteProcessorPromptOptions = exports.deleteProcessorPromptOptions = {
  message: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.message', {
    defaultMessage: 'Deleting this processor will permanently impact the field configuration.'
  }),
  title: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.title', {
    defaultMessage: 'Are you sure you want to delete this processor?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.confirmButtonText', {
    defaultMessage: 'Delete processor'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.cancelButtonText', {
    defaultMessage: 'Cancel'
  })
};