"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geoIpProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'geoip',
  field: '',
  target_field: '',
  database_file: '',
  properties: [],
  ignore_missing: false,
  first_only: true
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpFieldHelpText', {
    defaultMessage: 'The field to get the IP address from for the geographical lookup.'
  }),
  includeCondition: false,
  includeIgnoreFailures: false,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'target_field',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpTargetFieldHelpText",
    defaultMessage: "The field that will hold the geographical information looked up from the database."
  })
}, {
  field: 'database_file',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpDatabaseFileLabel', {
    defaultMessage: 'Database file'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpDatabaseFileHelpText",
    defaultMessage: "The database filename referring to one of the automatically downloaded GeoLite2 databases (GeoLite2-City.mmdb, GeoLite2-Country.mmdb, or GeoLite2-ASN.mmdb), or the name of a supported database file in the ingest-geoip config directory, or the name of a configured database (with the .mmdb suffix appended)."
  })
}, {
  field: 'properties',
  type: 'array',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpPropertiesLabel', {
    defaultMessage: 'Properties'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpPropertiesHelpText",
    defaultMessage: "Controls what properties are added to the {targetField} based on the ip geolocation lookup.",
    values: {
      targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "target_field")
    }
  })
}, {
  field: 'first_only',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpFirstOnlyLabel', {
    defaultMessage: 'First only'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpFirstOnlyHelpText",
    defaultMessage: "If true only the first found ip geolocation data will be returned."
  })
}];
const geoIpProcessorConfig = exports.geoIpProcessorConfig = {
  type: 'geoip',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpInputDisplay', {
    defaultMessage: 'GeoIP'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.geoIpHelpText",
      defaultMessage: "Adds information about the geographical location of an {geoIpLink}",
      values: {
        geoIpLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsGeoIpLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.geoIp
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.geoIpLinkLabel', {
          defaultMessage: 'IPv4 or IPv6 address.'
        }))
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('geoip', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('geoip', defaultFormState),
  fieldConfigurations,
  fieldOptions
};