"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorOutcomePreview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _grokUi = require("@kbn/grok-ui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _formatters = require("../../../util/formatters");
var _preview_table = require("../preview_table");
var _simulation_state_machine = require("./state_management/simulation_state_machine");
var _selectors = require("./state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _selectors2 = require("./state_management/stream_enrichment_state_machine/selectors");
var _utils = require("./utils");
var _asset_image = require("../../asset_image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorOutcomePreview = () => {
  const isLoading = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.matches('debouncingChanges') || snapshot.matches('runningSimulation'));
  const samples = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.context.samples);
  const areDataSourcesLoading = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.dataSourcesRefs.some(ref => {
    const snap = ref.getSnapshot();
    return snap.matches({
      enabled: 'loadingData'
    }) || snap.matches({
      enabled: 'debouncingChanges'
    });
  }));
  if ((0, _lodash.isEmpty)(samples)) {
    if (areDataSourcesLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        alignItems: "center",
        style: {
          minHeight: 200
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "warning",
      iconType: "warning",
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataTitle', {
        defaultMessage: 'No data available to validate processor changes'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataBody', {
        defaultMessage: 'Changes will be applied, but we can’t confirm they’ll work as expected. Proceed with caution.'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(PreviewDocumentsGroupBy, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(OutcomePreviewTable, null), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }));
};
exports.ProcessorOutcomePreview = ProcessorOutcomePreview;
const formatter = (0, _formatters.getPercentageFormatter)();
const formatRateToPercentage = rate => rate ? formatter.format(rate) : undefined; // This is a workaround for the type error, since the numFilters & numActiveFilters props are defined as number | undefined

const PreviewDocumentsGroupBy = () => {
  const {
    changePreviewDocsFilter
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const previewDocsFilter = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewDocsFilter);
  const simulationFailedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula;
    return formatRateToPercentage((_state$context$simula = state.context.simulation) === null || _state$context$simula === void 0 ? void 0 : _state$context$simula.documents_metrics.failed_rate);
  });
  const simulationSkippedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula2;
    return formatRateToPercentage((_state$context$simula2 = state.context.simulation) === null || _state$context$simula2 === void 0 ? void 0 : _state$context$simula2.documents_metrics.skipped_rate);
  });
  const simulationPartiallyParsedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula3;
    return formatRateToPercentage((_state$context$simula3 = state.context.simulation) === null || _state$context$simula3 === void 0 ? void 0 : _state$context$simula3.documents_metrics.partially_parsed_rate);
  });
  const simulationParsedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula4;
    return formatRateToPercentage((_state$context$simula4 = state.context.simulation) === null || _state$context$simula4 === void 0 ? void 0 : _state$context$simula4.documents_metrics.parsed_rate);
  });
  const getFilterButtonPropsFor = filter => ({
    isToggle: previewDocsFilter === filter,
    isSelected: previewDocsFilter === filter,
    hasActiveFilters: previewDocsFilter === filter,
    onClick: () => changePreviewDocsFilter(filter)
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControlsAriaLabel', {
      defaultMessage: 'Filter for all, matching or unmatching previewed documents.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_all.id), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_all.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_parsed.id), {
    badgeColor: "success",
    numFilters: simulationParsedRate,
    numActiveFilters: simulationParsedRate
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_parsed.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_partially_parsed.id), {
    badgeColor: "accent",
    numFilters: simulationPartiallyParsedRate,
    numActiveFilters: simulationPartiallyParsedRate
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_partially_parsed.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_skipped.id), {
    badgeColor: "accent",
    numFilters: simulationSkippedRate,
    numActiveFilters: simulationSkippedRate
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_skipped.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_failed.id), {
    badgeColor: "accent",
    numFilters: simulationFailedRate,
    numActiveFilters: simulationFailedRate
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_failed.label)));
};
const OutcomePreviewTable = () => {
  var _draftProcessor$resou;
  const processors = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.processors);
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula5;
    return (_state$context$simula5 = state.context.simulation) === null || _state$context$simula5 === void 0 ? void 0 : _state$context$simula5.detected_fields;
  });
  const previewDocsFilter = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewDocsFilter);
  const previewColumnsSorting = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewColumnsSorting);
  const explicitlyEnabledPreviewColumns = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.explicitlyEnabledPreviewColumns);
  const explicitlyDisabledPreviewColumns = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.explicitlyDisabledPreviewColumns);
  const previewColumnsOrder = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewColumnsOrder);
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewDocuments)(snapshot.context));
  const {
    setExplicitlyEnabledPreviewColumns,
    setExplicitlyDisabledPreviewColumns,
    setPreviewColumnsOrder,
    setPreviewColumnsSorting
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const allColumns = (0, _react.useMemo)(() => {
    // Get all fields from the preview documents
    const fields = new Set();
    previewDocuments.forEach(doc => {
      Object.keys(doc).forEach(key => {
        fields.add(key);
      });
    });
    return Array.from(fields);
  }, [previewDocuments]);
  const draftProcessor = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => (0, _selectors2.selectDraftProcessor)(snapshot.context));
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(machineState => machineState.context.grokCollection);
  const grokMode = (draftProcessor === null || draftProcessor === void 0 ? void 0 : draftProcessor.processor) && (0, _utils.isGrokProcessor)(draftProcessor.processor) && !(0, _lodash.isEmpty)(draftProcessor.processor.grok.field) &&
  // NOTE: If a Grok expression attempts to overwrite the configured field (non-additive change) we defer to the standard preview table showing all columns
  !((_draftProcessor$resou = draftProcessor.resources) !== null && _draftProcessor$resou !== void 0 && _draftProcessor$resou.grokExpressions.some(grokExpression => {
    var _draftProcessor$proce;
    if (draftProcessor.processor && !(0, _utils.isGrokProcessor)(draftProcessor.processor)) return false;
    const fieldName = (_draftProcessor$proce = draftProcessor.processor) === null || _draftProcessor$proce === void 0 ? void 0 : _draftProcessor$proce.grok.field;
    return Array.from(grokExpression.getFields().values()).some(field => field.name === fieldName);
  }));
  const grokField = grokMode ? draftProcessor.processor.grok.field : undefined;
  const previewColumns = (0, _react.useMemo)(() => {
    let cols = (0, _simulation_state_machine.getTableColumns)(processors, detectedFields !== null && detectedFields !== void 0 ? detectedFields : [], previewDocsFilter);
    if (grokField) {
      // If we are in Grok mode, we exclude the detected fields and only use the Grok field
      // sine it is highlighting extracted values
      cols = [grokField];
    }
    if (cols.length === 0) {
      // If no columns are detected, we fall back to all fields from the preview documents
      cols = allColumns;
    }
    // Filter out columns that are explicitly disabled
    const filteredCols = cols.filter(col => !explicitlyDisabledPreviewColumns.includes(col));
    // Add explicitly enabled columns if they are not already included and exist in allFields
    explicitlyEnabledPreviewColumns.forEach(col => {
      if (!filteredCols.includes(col) && allColumns.includes(col)) {
        filteredCols.push(col);
      }
    });
    return filteredCols;
  }, [allColumns, detectedFields, explicitlyDisabledPreviewColumns, explicitlyEnabledPreviewColumns, grokField, previewDocsFilter, processors]);
  const setVisibleColumns = visibleColumns => {
    if (visibleColumns.length === 0) {
      // If no columns are visible, we reset the explicitly enabled and disabled columns
      setExplicitlyDisabledPreviewColumns(allColumns);
      return;
    }
    // find which columns got added or removed comparing visibleColumns with the current displayColumns
    const addedColumns = visibleColumns.filter(col => !previewColumns.includes(col));
    if (addedColumns.length > 0) {
      setExplicitlyEnabledPreviewColumns([...explicitlyEnabledPreviewColumns, ...addedColumns.filter(col => !explicitlyEnabledPreviewColumns.includes(col))]);
    }
    const removedColumns = previewColumns.filter(col => !visibleColumns.includes(col));
    if (removedColumns.length > 0) {
      setExplicitlyDisabledPreviewColumns([...explicitlyDisabledPreviewColumns, ...removedColumns.filter(col => !explicitlyDisabledPreviewColumns.includes(col))]);
    }
    setPreviewColumnsOrder(visibleColumns);
  };
  if ((0, _lodash.isEmpty)(previewDocuments)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsTitle', {
        defaultMessage: 'No documents available'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsBody', {
        defaultMessage: 'The current filter settings do not match any documents.'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
    documents: previewDocuments,
    displayColumns: previewColumns,
    rowHeightsOptions: grokMode ? {
      defaultHeight: 'auto'
    } : undefined,
    toolbarVisibility: true,
    setVisibleColumns: setVisibleColumns,
    sorting: previewColumnsSorting,
    setSorting: setPreviewColumnsSorting,
    columnOrderHint: previewColumnsOrder,
    renderCellValue: grokMode ? (document, columnId) => {
      const value = document[columnId];
      if (typeof value === 'string' && columnId === grokField) {
        var _draftProcessor$resou2, _draftProcessor$resou3;
        return /*#__PURE__*/_react.default.createElement(_grokUi.Sample, {
          grokCollection: grokCollection,
          draftGrokExpressions: (_draftProcessor$resou2 = (_draftProcessor$resou3 = draftProcessor.resources) === null || _draftProcessor$resou3 === void 0 ? void 0 : _draftProcessor$resou3.grokExpressions) !== null && _draftProcessor$resou2 !== void 0 ? _draftProcessor$resou2 : [],
          sample: value
        });
      } else {
        return undefined;
      }
    } : undefined
  });
};