"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseNextURL = parseNextURL;
var _url = require("url");
var _is_internal_url = require("./is_internal_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_NEXT_URL_QUERY_STRING_PARAMETER = 'next';

/**
 * Parse the url value from query param. By default
 *
 * By default query param is set to next.
 */
function parseNextURL(href, basePath = '', nextUrlQueryParam = DEFAULT_NEXT_URL_QUERY_STRING_PARAMETER) {
  const {
    query,
    hash
  } = (0, _url.parse)(href, true);
  let next = query[nextUrlQueryParam];
  if (!next) {
    return `${basePath}/`;
  }
  if (Array.isArray(next) && next.length > 0) {
    next = next[0];
  } else {
    next = next;
  }

  // validate that `next` is not attempting a redirect to somewhere
  // outside of this Kibana install.
  if (!(0, _is_internal_url.isInternalURL)(next, basePath)) {
    return `${basePath}/`;
  }
  return next + (hash || '');
}