"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.incidentSchemaObjectProperties = exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionGetIssuesParamsSchema = exports.ExecutorSubActionGetIssueTypesParamsSchema = exports.ExecutorSubActionGetIssueParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetFieldsByIssueTypeParamsSchema = exports.ExecutorSubActionGetCapabilitiesParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/jira/constants");
var _validators = require("../lib/validators");
var _validators2 = require("./validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  apiUrl: _configSchema.schema.string(),
  projectKey: _configSchema.schema.string()
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceConfiguration);
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  email: _configSchema.schema.string(),
  apiToken: _configSchema.schema.string()
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceSecretConfiguration);
const incidentSchemaObject = {
  summary: _configSchema.schema.string(),
  description: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalId: _configSchema.schema.nullable(_configSchema.schema.string()),
  issueType: _configSchema.schema.nullable(_configSchema.schema.string()),
  priority: _configSchema.schema.nullable(_configSchema.schema.string()),
  labels: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string({
    validate: label =>
    // Matches any space, tab or newline character.
    label.match(/\s/g) ? `The label ${label} cannot contain spaces` : undefined
  }))),
  parent: _configSchema.schema.nullable(_configSchema.schema.string()),
  otherFields: _configSchema.schema.nullable(_configSchema.schema.recordOf(_configSchema.schema.string({
    validate: value => (0, _validators2.validateOtherFieldsKeys)(value)
  }), _configSchema.schema.any(), {
    validate: value => (0, _validators.validateRecordMaxKeys)({
      record: value,
      maxNumberOfFields: _constants.MAX_OTHER_FIELDS_LENGTH,
      fieldName: 'otherFields'
    })
  }))
};
const incidentSchemaObjectProperties = exports.incidentSchemaObjectProperties = Object.keys(incidentSchemaObject);
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _configSchema.schema.object({
  incident: _configSchema.schema.object(incidentSchemaObject),
  comments: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    comment: _configSchema.schema.string(),
    commentId: _configSchema.schema.string()
  })))
});
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _configSchema.schema.object({
  externalId: _configSchema.schema.string()
});

// Reserved for future implementation
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetCapabilitiesParamsSchema = exports.ExecutorSubActionGetCapabilitiesParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetIssueTypesParamsSchema = exports.ExecutorSubActionGetIssueTypesParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetFieldsByIssueTypeParamsSchema = exports.ExecutorSubActionGetFieldsByIssueTypeParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const ExecutorSubActionGetIssuesParamsSchema = exports.ExecutorSubActionGetIssuesParamsSchema = _configSchema.schema.object({
  title: _configSchema.schema.string()
});
const ExecutorSubActionGetIssueParamsSchema = exports.ExecutorSubActionGetIssueParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  subAction: _configSchema.schema.literal('getFields'),
  subActionParams: ExecutorSubActionCommonFieldsParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('getIncident'),
  subActionParams: ExecutorSubActionGetIncidentParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('handshake'),
  subActionParams: ExecutorSubActionHandshakeParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('issueTypes'),
  subActionParams: ExecutorSubActionGetIssueTypesParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('fieldsByIssueType'),
  subActionParams: ExecutorSubActionGetFieldsByIssueTypeParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('issues'),
  subActionParams: ExecutorSubActionGetIssuesParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('issue'),
  subActionParams: ExecutorSubActionGetIssueParamsSchema
})]);