"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JIRA_TITLE = exports.JIRA_DESC = void 0;
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/jira/constants");
var _validate_json = require("../lib/validate_json");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JIRA_DESC = exports.JIRA_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.jira.selectMessageText', {
  defaultMessage: 'Create an incident in Jira.'
});
const JIRA_TITLE = exports.JIRA_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.jira.connectorTypeTitle', {
  defaultMessage: 'Jira'
});
function getConnectorType() {
  return {
    id: '.jira',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: JIRA_DESC,
    actionTypeTitle: JIRA_TITLE,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./jira_connectors')))),
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2, _actionParams$subActi3, _actionParams$subActi4, _actionParams$subActi5, _actionParams$subActi6;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'subActionParams.incident.summary': new Array(),
        'subActionParams.incident.labels': new Array(),
        'subActionParams.incident.otherFields': new Array()
      };
      const validationResult = {
        errors
      };
      if (actionParams.subActionParams && actionParams.subActionParams.incident && !((_actionParams$subActi = actionParams.subActionParams.incident.summary) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.summary'].push(translations.SUMMARY_REQUIRED);
      }
      if ((_actionParams$subActi2 = actionParams.subActionParams) !== null && _actionParams$subActi2 !== void 0 && (_actionParams$subActi3 = _actionParams$subActi2.incident) !== null && _actionParams$subActi3 !== void 0 && (_actionParams$subActi4 = _actionParams$subActi3.labels) !== null && _actionParams$subActi4 !== void 0 && _actionParams$subActi4.length) {
        // Jira do not allows empty spaces on labels. If the label includes a whitespace show an error.
        if (actionParams.subActionParams.incident.labels.some(label => label.match(/\s/g))) errors['subActionParams.incident.labels'].push(translations.LABELS_WHITE_SPACES);
      }
      const jsonErrors = (0, _validate_json.validateJSON)({
        value: (_actionParams$subActi5 = actionParams.subActionParams) === null || _actionParams$subActi5 === void 0 ? void 0 : (_actionParams$subActi6 = _actionParams$subActi5.incident) === null || _actionParams$subActi6 === void 0 ? void 0 : _actionParams$subActi6.otherFields,
        maxProperties: _constants.MAX_OTHER_FIELDS_LENGTH
      });
      if (jsonErrors) {
        errors['subActionParams.incident.otherFields'] = [jsonErrors];
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./jira_params'))))
  };
}