"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThresholdRuleVisualizationData = getThresholdRuleVisualizationData;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_THRESHOLD_DATA_API_ROOT = '/internal/triggers_actions_ui/data';
async function getThresholdRuleVisualizationData({
  model,
  visualizeOptions,
  http
}) {
  const timeSeriesQueryParams = {
    index: model.index,
    timeField: model.timeField,
    aggType: model.aggType,
    aggField: model.aggField,
    groupBy: model.groupBy,
    termField: model.termField,
    termSize: model.termSize,
    timeWindowSize: model.timeWindowSize,
    timeWindowUnit: model.timeWindowUnit,
    filterKuery: model.filterKuery,
    dateStart: new Date(visualizeOptions.rangeFrom).toISOString(),
    dateEnd: new Date(visualizeOptions.rangeTo).toISOString(),
    interval: visualizeOptions.interval
  };
  return await http.post(`${INDEX_THRESHOLD_DATA_API_ROOT}/_time_series_query`, {
    body: JSON.stringify(timeSeriesQueryParams)
  });
}