"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initGetSpaceApi = initGetSpaceApi;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
var _common = require("../../../../common");
var _errors = require("../../../lib/errors");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initGetSpaceApi(deps) {
  const {
    router,
    getSpacesService
  } = deps;
  router.versioned.get({
    path: '/api/spaces/space/{id}',
    access: 'public',
    summary: `Get a space`,
    options: {
      tags: ['oas-tag:spaces']
    },
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the spaces service via a scoped spaces client'
      }
    }
  }).addVersion({
    version: _common.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            meta: {
              description: 'The space identifier.'
            }
          })
        })
      },
      response: {
        200: {
          description: 'Indicates a successful call.'
        }
      }
    }
  }, (0, _lib.createLicensedRouteHandler)(async (context, request, response) => {
    const spaceId = request.params.id;
    const spacesClient = getSpacesService().createSpacesClient(request);
    try {
      const space = await spacesClient.get(spaceId);
      return response.ok({
        body: space
      });
    } catch (error) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(error)) {
        return response.notFound();
      }
      return response.customError((0, _errors.wrapError)(error));
    }
  }));
}