"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSpace = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("./constants");
var _handle_api_error = require("./handle_api_error");
var _use_tabs = require("./hooks/use_tabs");
var _provider = require("./provider");
var _common = require("../../../common");
var _constants2 = require("../../../common/constants");
var _space_avatar = require("../../space_avatar");
var _space_solution_badge = require("../../space_solution_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const getSelectedTabId = (canUserViewRoles, selectedTabId) => {
  // Validation of the selectedTabId routing parameter, default to the Content tab
  return selectedTabId && [_constants.TAB_ID_CONTENT, canUserViewRoles ? _constants.TAB_ID_ROLES : null].filter(Boolean).includes(selectedTabId) ? selectedTabId : _constants.TAB_ID_GENERAL;
};
const EditSpace = ({
  spaceId,
  getFeatures,
  history,
  onLoadSpace,
  selectedTabId: _selectedTabId,
  ...props
}) => {
  var _capabilities$roles;
  const {
    state,
    dispatch
  } = (0, _provider.useEditSpaceStore)();
  const {
    invokeClient
  } = (0, _provider.useEditSpaceServices)();
  const {
    spacesManager,
    capabilities,
    serverBasePath,
    logger,
    notifications,
    isRoleManagementEnabled,
    license,
    enableSecurityLink
  } = (0, _provider.useEditSpaceServices)();
  const [space, setSpace] = (0, _react.useState)(null);
  const [userActiveSpace, setUserActiveSpace] = (0, _react.useState)(null);
  const [features, setFeatures] = (0, _react.useState)(null);
  const [isLoadingSpace, setIsLoadingSpace] = (0, _react.useState)(true);
  const [isLoadingFeatures, setIsLoadingFeatures] = (0, _react.useState)(true);
  const [isLoadingRoles, setIsLoadingRoles] = (0, _react.useState)(true);
  const selectedTabId = getSelectedTabId(Boolean(capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$roles = capabilities.roles) === null || _capabilities$roles === void 0 ? void 0 : _capabilities$roles.view), _selectedTabId);
  const isSecurityEnabled = Boolean(license === null || license === void 0 ? void 0 : license.isEnabled());
  const [tabs, selectedTabContent] = (0, _use_tabs.useTabs)({
    space,
    features,
    isRoleManagementEnabled,
    rolesCount: state.roles.size,
    capabilities,
    history,
    currentSelectedTabId: selectedTabId,
    isSecurityEnabled,
    enableSecurityLink,
    ...props
  });
  (0, _react.useEffect)(() => {
    if (!spaceId) {
      return;
    }
    const getSpaceInfo = async () => {
      // active space: the space that is active in the user's session
      // current space: the space being edited by the user
      const [activeSpace, currentSpace] = await Promise.all([spacesManager.getActiveSpace(), spacesManager.getSpace(spaceId)]);
      setSpace(currentSpace);
      setUserActiveSpace(activeSpace);
      setIsLoadingSpace(false);
    };
    getSpaceInfo().catch(error => (0, _handle_api_error.handleApiError)(error, {
      logger,
      toasts: notifications.toasts
    }));
  }, [spaceId, spacesManager, logger, notifications.toasts]);

  // Load roles to show the count of assigned roles as a badge in the "Assigned roles" tab title
  (0, _react.useEffect)(() => {
    if (!spaceId) {
      return;
    }
    const getRoles = async () => {
      await invokeClient(async clients => {
        let result = [];
        try {
          result = await clients.spacesManager.getRolesForSpace(spaceId);
        } catch (error) {
          var _error$body$message, _error$body, _error$body$statusCod, _error$body2;
          const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.toString();
          const statusCode = (_error$body$statusCod = error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.statusCode) !== null && _error$body$statusCod !== void 0 ? _error$body$statusCod : null;
          if (statusCode === 403) {
            logger.error('Insufficient permissions to get list of roles for the space');
            logger.error(message);
          } else {
            logger.error('Encountered error while getting list of roles for space!');
            logger.error(error);
          }
          dispatch({
            type: 'fetch_roles_error',
            payload: true
          });
        }
        dispatch({
          type: 'update_roles',
          payload: result
        });
      });
      setIsLoadingRoles(false);
    };
    if (isRoleManagementEnabled && !state.roles.size && !state.fetchRolesError) {
      getRoles();
    }
  }, [dispatch, invokeClient, spaceId, logger, state.roles, state.fetchRolesError, isRoleManagementEnabled]);
  (0, _react.useEffect)(() => {
    const _getFeatures = async () => {
      const result = await getFeatures();
      setFeatures(result);
      setIsLoadingFeatures(false);
    };
    _getFeatures().catch(error => (0, _handle_api_error.handleApiError)(error, {
      logger,
      toasts: notifications.toasts
    }));
  }, [getFeatures, logger, notifications.toasts]);
  (0, _react.useEffect)(() => {
    if (space) {
      onLoadSpace === null || onLoadSpace === void 0 ? void 0 : onLoadSpace(space);
    }
  }, [onLoadSpace, space]);
  if (!space) {
    return null;
  }
  if (isLoadingSpace || isLoadingFeatures || isRoleManagementEnabled && isLoadingRoles) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    })));
  }
  const HeaderAvatar = () => {
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: space,
      size: "xl"
    }));
  };
  const {
    id,
    solution: spaceSolution
  } = space;
  const solution = spaceSolution !== null && spaceSolution !== void 0 ? spaceSolution : _constants2.SOLUTION_VIEW_CLASSIC;
  const shouldShowSolutionBadge = props.allowSolutionVisibility || solution !== _constants2.SOLUTION_VIEW_CLASSIC;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "spaces-view-page"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "space-view-page-details-header",
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      flexBasis: '100%',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginTop: '4px'
    }
  }, /*#__PURE__*/_react.default.createElement(HeaderAvatar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    "data-test-subj": "spaces-view-page-title"
  }, space.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (userActiveSpace === null || userActiveSpace === void 0 ? void 0 : userActiveSpace.id) !== id ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "push",
    href: (0, _common.addSpaceIdToPath)(serverBasePath, id, `${_common.ENTER_SPACE_PATH}?next=/app/management/kibana/spaces/edit/${id}`),
    "data-test-subj": "spaces-view-page-switcher-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.spaceDetails.space.switchToSpaceButton.label",
    defaultMessage: "Switch to this space"
  })) : null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginTop: '4px'
    }
  }, /*#__PURE__*/_react.default.createElement("div", null, shouldShowSolutionBadge ? /*#__PURE__*/_react.default.createElement(_space_solution_badge.SpaceSolutionBadge, {
    solution: solution,
    "data-test-subj": `space-solution-badge-${solution}`
  }) : null, (userActiveSpace === null || userActiveSpace === void 0 ? void 0 : userActiveSpace.id) === id ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.spaceDetails.space.badge.isCurrent",
    description: "Text for a badge shown in the Space details page when the particular Space currently active.",
    defaultMessage: "Current"
  })) : null)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, space.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    key: index,
    isSelected: tab.id === selectedTabId,
    append: tab.append
  }, (0, _public.reactRouterNavigate)(history, `/edit/${encodeURIComponent(id)}/${tab.id}`)), tab.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, selectedTabContent !== null && selectedTabContent !== void 0 ? selectedTabContent : null)));
};
exports.EditSpace = EditSpace;