"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _section_panel = require("../section_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOptions = ({
  size
}) => {
  const iconCss = {
    marginRight: size.m
  };
  return [{
    value: 'es',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElasticsearch",
      css: iconCss
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.searchOptionLabel', {
      defaultMessage: 'Elasticsearch'
    })),
    'data-test-subj': 'solutionViewEsOption'
  }, {
    value: 'oblt',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      css: iconCss
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.obltOptionLabel', {
      defaultMessage: 'Observability'
    })),
    'data-test-subj': 'solutionViewObltOption'
  }, {
    value: 'security',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoSecurity",
      css: iconCss
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.securityOptionLabel', {
      defaultMessage: 'Security'
    })),
    'data-test-subj': 'solutionViewSecurityOption'
  }, {
    value: 'classic',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElasticStack",
      css: iconCss
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.classicOptionLabel', {
      defaultMessage: 'Classic'
    })),
    'data-test-subj': 'solutionViewClassicOption'
  }];
};
const SolutionView = ({
  space,
  onChange,
  validator,
  isEditing,
  sectionTitle
}) => {
  var _space$solution;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const showClassicDefaultViewCallout = isEditing && space.solution == null;
  return /*#__PURE__*/_react.default.createElement(_section_panel.SectionPanel, {
    title: sectionTitle,
    dataTestSubj: "navigationPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.manageSpacePage.setSolutionViewMessage",
    defaultMessage: "Select solution view"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.setSolutionViewNewBadge', {
      defaultMessage: 'New'
    }),
    color: "accent",
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.manageSpacePage.setSolutionViewDescription",
    defaultMessage: "Focus the navigation and menus of this space on a specific solution. Features that are not relevant to the selected solution are no longer visible to users of this space."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.spaces.management.navigation.solutionViewLabel', {
      defaultMessage: 'Solution view'
    }),
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showClassicDefaultViewCallout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.manageSpacePage.solutionViewSelect.classicDefaultViewCallout",
      defaultMessage: "Affects all users of the space"
    }) : null)
  }, validator.validateSolutionView(space, isEditing)), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: getOptions(euiTheme),
    valueOfSelected: (_space$solution = space.solution) !== null && _space$solution !== void 0 ? _space$solution : showClassicDefaultViewCallout ? _constants.SOLUTION_VIEW_CLASSIC : undefined,
    "data-test-subj": "solutionViewSelect",
    onChange: solution => {
      onChange({
        ...space,
        solution
      });
    },
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.spaces.management.navigation.solutionViewDefaultValue', {
      defaultMessage: 'Select solution view'
    }),
    isInvalid: validator.validateSolutionView(space, isEditing).isInvalid
  })))));
};
exports.SolutionView = SolutionView;