"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.verifyRepository = exports.useLoadRepositoryTypes = exports.useLoadRepository = exports.useLoadRepositories = exports.setUiMetricServiceRepository = exports.editRepository = exports.deleteRepositories = exports.cleanupRepository = exports.addRepository = void 0;
var _constants = require("../../../../common/constants");
var _constants2 = require("../../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary hack to provide the uiMetricService instance to this file.
// TODO: Refactor and export an ApiService instance through the app dependencies context
let uiMetricService;
const setUiMetricServiceRepository = _uiMetricService => {
  uiMetricService = _uiMetricService;
};
// End hack
exports.setUiMetricServiceRepository = setUiMetricServiceRepository;
const useLoadRepositories = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}repositories`,
    method: 'get',
    initialData: []
  });
};
exports.useLoadRepositories = useLoadRepositories;
const useLoadRepository = name => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}repositories/${encodeURIComponent(name)}`,
    method: 'get'
  });
};
exports.useLoadRepository = useLoadRepository;
const verifyRepository = async name => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}repositories/${encodeURIComponent(name)}/verify`,
    method: 'get'
  });
  uiMetricService.trackUiMetric(_constants2.UIM_REPOSITORY_DETAIL_PANEL_VERIFY);
  return result;
};
exports.verifyRepository = verifyRepository;
const cleanupRepository = async name => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}repositories/${encodeURIComponent(name)}/cleanup`,
    method: 'post',
    body: undefined
  });
  uiMetricService.trackUiMetric(_constants2.UIM_REPOSITORY_DETAIL_PANEL_CLEANUP);
  return result;
};
exports.cleanupRepository = cleanupRepository;
const useLoadRepositoryTypes = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}repository_types`,
    method: 'get',
    initialData: []
  });
};
exports.useLoadRepositoryTypes = useLoadRepositoryTypes;
const addRepository = async newRepository => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}repositories`,
    method: 'put',
    body: newRepository
  });
  uiMetricService.trackUiMetric(_constants2.UIM_REPOSITORY_CREATE);
  return result;
};
exports.addRepository = addRepository;
const editRepository = async editedRepository => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}repositories/${encodeURIComponent(editedRepository.name)}`,
    method: 'put',
    body: editedRepository
  });
  uiMetricService.trackUiMetric(_constants2.UIM_REPOSITORY_UPDATE);
  return result;
};
exports.editRepository = editRepository;
const deleteRepositories = async names => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}repositories/${names.map(name => encodeURIComponent(name)).join(',')}`,
    method: 'delete'
  });
  uiMetricService.trackUiMetric(names.length > 1 ? _constants2.UIM_REPOSITORY_DELETE_MANY : _constants2.UIM_REPOSITORY_DELETE);
  return result;
};
exports.deleteRepositories = deleteRepositories;