"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotStepSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../../../constants");
var _app_context = require("../../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshotStepSettings = ({
  restoreSettings,
  updateRestoreSettings,
  snapshotDetails,
  errors
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    indexSettings,
    ignoreIndexSettings
  } = restoreSettings;
  const {
    dataStreams
  } = snapshotDetails;

  // State for index setting toggles
  const [isUsingIndexSettings, setIsUsingIndexSettings] = (0, _react.useState)(Boolean(indexSettings));
  const [isUsingIgnoreIndexSettings, setIsUsingIgnoreIndexSettings] = (0, _react.useState)(Boolean(ignoreIndexSettings));

  // Caching state for togglable settings
  const [cachedRestoreSettings, setCachedRestoreSettings] = (0, _react.useState)({
    indexSettings: indexSettings || '{}',
    ignoreIndexSettings: ignoreIndexSettings ? [...ignoreIndexSettings] : []
  });

  // List of settings for ignore settings combobox suggestions, using a state because users can add custom settings
  const [ignoreIndexSettingsOptions, setIgnoreIndexSettingsOptions] = (0, _react.useState)([...new Set((ignoreIndexSettings || []).concat([..._constants.REMOVE_INDEX_SETTINGS_SUGGESTIONS].sort()))].map(setting => ({
    label: setting
  })));

  // Index settings doc link
  const indexSettingsDocLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.elasticsearch.indexModules,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDocLinkText",
    defaultMessage: "Learn more."
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "snapshotRestore__restoreForm__stepSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "indexSettingsTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettingsTitle",
    defaultMessage: "Index settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.snapshotRestore.changeIndexSettings,
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.docsButtonLabel",
    defaultMessage: "Index settings docs"
  })))), dataStreams !== null && dataStreams !== void 0 && dataStreams.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "question",
    title: i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.title', {
      defaultMessage: 'Backing indices'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.description",
    defaultMessage: "These settings also apply to the backing indices of data streams."
  }))) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsTitle",
      defaultMessage: "Modify index settings"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDescription",
      defaultMessage: "Overrides index settings during restore. {docLink}",
      values: {
        docLink: indexSettingsDocLink
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "modifyIndexSettingsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsLabel",
      defaultMessage: "Modify index settings"
    }),
    checked: isUsingIndexSettings,
    onChange: e => {
      const isChecked = e.target.checked;
      if (isChecked) {
        setIsUsingIndexSettings(true);
        updateRestoreSettings({
          indexSettings: cachedRestoreSettings.indexSettings
        });
      } else {
        setIsUsingIndexSettings(false);
        updateRestoreSettings({
          indexSettings: undefined
        });
      }
    }
  }), !isUsingIndexSettings ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorLabel",
      defaultMessage: "Index settings"
    }),
    fullWidth: true,
    isInvalid: Boolean(errors.indexSettings),
    error: errors.indexSettings,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorDescription",
      defaultMessage: "Use JSON format: {format}",
      values: {
        format: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '{ "index.number_of_replicas": 0 }')
      }
    }),
    "data-test-subj": "indexSettingsEditor"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: indexSettings,
    height: 250,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsAriaLabel', {
      defaultMessage: 'Index settings to modify'
    }),
    onChange: value => {
      updateRestoreSettings({
        indexSettings: value
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        indexSettings: value
      });
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsTitle",
      defaultMessage: "Reset index settings"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsDescription",
      defaultMessage: "Resets selected settings to default during restore. {docLink}",
      values: {
        docLink: indexSettingsDocLink
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsLabel",
      defaultMessage: "Reset index settings"
    }),
    checked: isUsingIgnoreIndexSettings,
    onChange: e => {
      const isChecked = e.target.checked;
      if (isChecked) {
        setIsUsingIgnoreIndexSettings(true);
        updateRestoreSettings({
          ignoreIndexSettings: [...(cachedRestoreSettings.ignoreIndexSettings || [])]
        });
      } else {
        setIsUsingIgnoreIndexSettings(false);
        updateRestoreSettings({
          ignoreIndexSettings: undefined
        });
      }
    }
  }), !isUsingIgnoreIndexSettings ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.selectIgnoreIndexSettingsLabel",
      defaultMessage: "Select settings"
    }),
    isInvalid: Boolean(errors.ignoreIndexSettings),
    error: errors.ignoreIndexSettings
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: Boolean(errors.ignoreIndexSettings),
    placeholder: i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsPlaceholder', {
      defaultMessage: 'Select or type index settings'
    }),
    options: ignoreIndexSettingsOptions,
    selectedOptions: ignoreIndexSettings ? ignoreIndexSettingsOptions.filter(({
      label
    }) => ignoreIndexSettings.includes(label)) : [],
    onChange: selectedOptions => {
      const newIgnoreIndexSettings = selectedOptions.map(({
        label
      }) => label);
      updateRestoreSettings({
        ignoreIndexSettings: newIgnoreIndexSettings
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        ignoreIndexSettings: newIgnoreIndexSettings
      });
    },
    onCreateOption: (newIndexSetting, flattenedOptions) => {
      const normalizedSettingName = newIndexSetting.trim().toLowerCase();
      if (!normalizedSettingName) {
        return;
      }
      const isCustomSetting = !Boolean(flattenedOptions.find(({
        label
      }) => label === normalizedSettingName));
      if (isCustomSetting) {
        setIgnoreIndexSettingsOptions([{
          label: normalizedSettingName
        }, ...ignoreIndexSettingsOptions]);
      }
      updateRestoreSettings({
        ignoreIndexSettings: [...(ignoreIndexSettings || []), normalizedSettingName]
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        ignoreIndexSettings: [...(ignoreIndexSettings || []), normalizedSettingName]
      });
    },
    isClearable: true
  })))))));
};
exports.RestoreSnapshotStepSettings = RestoreSnapshotStepSettings;