"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timesliceMetricPercentileMetric = exports.timesliceMetricMetricDef = exports.timesliceMetricIndicatorTypeSchema = exports.timesliceMetricIndicatorSchema = exports.timesliceMetricDocCountMetric = exports.timesliceMetricComparatorMapping = exports.timesliceMetricBasicMetricWithField = exports.syntheticsAvailabilityIndicatorTypeSchema = exports.syntheticsAvailabilityIndicatorSchema = exports.querySchema = exports.metricCustomIndicatorTypeSchema = exports.metricCustomIndicatorSchema = exports.metricCustomDocCountMetric = exports.metricCustomBasicMetric = exports.kqlWithFiltersSchema = exports.kqlQuerySchema = exports.kqlCustomIndicatorTypeSchema = exports.kqlCustomIndicatorSchema = exports.indicatorTypesSchema = exports.indicatorTypesArraySchema = exports.indicatorSchema = exports.histogramIndicatorTypeSchema = exports.histogramIndicatorSchema = exports.filtersSchema = exports.apmTransactionErrorRateIndicatorTypeSchema = exports.apmTransactionErrorRateIndicatorSchema = exports.apmTransactionDurationIndicatorTypeSchema = exports.apmTransactionDurationIndicatorSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kqlQuerySchema = exports.kqlQuerySchema = t.string;
const filtersSchema = exports.filtersSchema = t.array(t.intersection([t.type({
  meta: t.partial({
    alias: t.union([t.string, t.null]),
    disabled: t.boolean,
    negate: t.boolean,
    // controlledBy is there to identify who owns the filter
    controlledBy: t.string,
    // allows grouping of filters
    group: t.string,
    // index and type are optional only because when you create a new filter, there are no defaults
    index: t.string,
    isMultiIndex: t.boolean,
    type: t.string,
    key: t.string,
    field: t.string,
    params: t.any,
    value: t.string
  }),
  query: t.record(t.string, t.any)
}), t.partial({
  $state: t.any
})]));
const kqlWithFiltersSchema = exports.kqlWithFiltersSchema = t.type({
  kqlQuery: t.string,
  filters: filtersSchema
});
const querySchema = exports.querySchema = t.union([kqlQuerySchema, kqlWithFiltersSchema]);
const apmTransactionDurationIndicatorTypeSchema = exports.apmTransactionDurationIndicatorTypeSchema = t.literal('sli.apm.transactionDuration');
const apmTransactionDurationIndicatorSchema = exports.apmTransactionDurationIndicatorSchema = t.type({
  type: apmTransactionDurationIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    threshold: t.number,
    index: t.string
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const apmTransactionErrorRateIndicatorTypeSchema = exports.apmTransactionErrorRateIndicatorTypeSchema = t.literal('sli.apm.transactionErrorRate');
const apmTransactionErrorRateIndicatorSchema = exports.apmTransactionErrorRateIndicatorSchema = t.type({
  type: apmTransactionErrorRateIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    index: t.string
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const kqlCustomIndicatorTypeSchema = exports.kqlCustomIndicatorTypeSchema = t.literal('sli.kql.custom');
const kqlCustomIndicatorSchema = exports.kqlCustomIndicatorSchema = t.type({
  type: kqlCustomIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    good: querySchema,
    total: querySchema,
    timestampField: t.string
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const timesliceMetricComparatorMapping = exports.timesliceMetricComparatorMapping = {
  GT: '>',
  GTE: '>=',
  LT: '<',
  LTE: '<='
};
const timesliceMetricComparator = t.keyof(timesliceMetricComparatorMapping);
const timesliceMetricBasicMetricWithField = exports.timesliceMetricBasicMetricWithField = t.intersection([t.type({
  name: t.string,
  aggregation: t.keyof({
    avg: true,
    max: true,
    min: true,
    sum: true,
    cardinality: true,
    last_value: true,
    std_deviation: true
  }),
  field: t.string
}), t.partial({
  filter: querySchema
})]);
const timesliceMetricDocCountMetric = exports.timesliceMetricDocCountMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('doc_count')
}), t.partial({
  filter: querySchema
})]);
const timesliceMetricPercentileMetric = exports.timesliceMetricPercentileMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('percentile'),
  field: t.string,
  percentile: t.number
}), t.partial({
  filter: querySchema
})]);
const timesliceMetricMetricDef = exports.timesliceMetricMetricDef = t.union([timesliceMetricBasicMetricWithField, timesliceMetricDocCountMetric, timesliceMetricPercentileMetric]);
const timesliceMetricDef = t.type({
  metrics: t.array(timesliceMetricMetricDef),
  equation: t.string,
  threshold: t.number,
  comparator: timesliceMetricComparator
});
const timesliceMetricIndicatorTypeSchema = exports.timesliceMetricIndicatorTypeSchema = t.literal('sli.metric.timeslice');
const timesliceMetricIndicatorSchema = exports.timesliceMetricIndicatorSchema = t.type({
  type: timesliceMetricIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    metric: timesliceMetricDef,
    timestampField: t.string
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const metricCustomDocCountMetric = exports.metricCustomDocCountMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('doc_count')
}), t.partial({
  filter: querySchema
})]);
const metricCustomBasicMetric = exports.metricCustomBasicMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('sum'),
  field: t.string
}), t.partial({
  filter: querySchema
})]);
const metricCustomMetricDef = t.type({
  metrics: t.array(t.union([metricCustomBasicMetric, metricCustomDocCountMetric])),
  equation: t.string
});
const metricCustomIndicatorTypeSchema = exports.metricCustomIndicatorTypeSchema = t.literal('sli.metric.custom');
const metricCustomIndicatorSchema = exports.metricCustomIndicatorSchema = t.type({
  type: metricCustomIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    good: metricCustomMetricDef,
    total: metricCustomMetricDef,
    timestampField: t.string
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const rangeHistogramMetricType = t.literal('range');
const rangeBasedHistogramMetricDef = t.intersection([t.type({
  field: t.string,
  aggregation: rangeHistogramMetricType,
  from: t.number,
  to: t.number
}), t.partial({
  filter: querySchema
})]);
const valueCountHistogramMetricType = t.literal('value_count');
const valueCountBasedHistogramMetricDef = t.intersection([t.type({
  field: t.string,
  aggregation: valueCountHistogramMetricType
}), t.partial({
  filter: querySchema
})]);
const histogramMetricDef = t.union([valueCountBasedHistogramMetricDef, rangeBasedHistogramMetricDef]);
const histogramIndicatorTypeSchema = exports.histogramIndicatorTypeSchema = t.literal('sli.histogram.custom');
const histogramIndicatorSchema = exports.histogramIndicatorSchema = t.type({
  type: histogramIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    timestampField: t.string,
    good: histogramMetricDef,
    total: histogramMetricDef
  }), t.partial({
    filter: querySchema,
    dataViewId: t.string
  })])
});
const syntheticsParamSchema = t.type({
  value: _common.allOrAnyString,
  label: _common.allOrAnyString
});
const syntheticsAvailabilityIndicatorTypeSchema = exports.syntheticsAvailabilityIndicatorTypeSchema = t.literal('sli.synthetics.availability');
const syntheticsAvailabilityIndicatorSchema = exports.syntheticsAvailabilityIndicatorSchema = t.type({
  type: syntheticsAvailabilityIndicatorTypeSchema,
  params: t.intersection([t.type({
    monitorIds: t.array(syntheticsParamSchema),
    index: t.string
  }), t.partial({
    tags: t.array(syntheticsParamSchema),
    projects: t.array(syntheticsParamSchema),
    filter: querySchema,
    dataViewId: t.string
  })])
});
const indicatorTypesSchema = exports.indicatorTypesSchema = t.union([apmTransactionDurationIndicatorTypeSchema, apmTransactionErrorRateIndicatorTypeSchema, syntheticsAvailabilityIndicatorTypeSchema, kqlCustomIndicatorTypeSchema, metricCustomIndicatorTypeSchema, timesliceMetricIndicatorTypeSchema, histogramIndicatorTypeSchema]);

// Validate that a string is a comma separated list of indicator types,
// e.g. sli.kql.custom,sli.apm.transactionDuration
// Transform to an array of indicator type
const indicatorTypesArraySchema = exports.indicatorTypesArraySchema = new t.Type('indicatorTypesArray', input => Array.isArray(input) && input.every(i => typeof i === 'string'), (input, context) => {
  if (typeof input === 'string') {
    const values = input.split(',');
    if (values.every(value => typeof value === 'string' && indicatorTypesSchema.is(value))) {
      return t.success(values);
    }
  }
  return t.failure(input, context);
}, values => values.join(','));
const indicatorSchema = exports.indicatorSchema = t.union([apmTransactionDurationIndicatorSchema, apmTransactionErrorRateIndicatorSchema, syntheticsAvailabilityIndicatorSchema, kqlCustomIndicatorSchema, metricCustomIndicatorSchema, timesliceMetricIndicatorSchema, histogramIndicatorSchema]);