"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOsOverview = SLOsOverview;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _slo_overview_alerts = require("./slo_overview_alerts");
var _use_get_settings = require("../../../slo_settings/hooks/use_get_settings");
var _use_fetch_slos_overview = require("../../hooks/use_fetch_slos_overview");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _overview_item = require("./overview_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOsOverview() {
  var _currentSettings$stal, _currentSettings$stal2;
  const {
    state
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    kqlQuery,
    filters,
    tagsFilter,
    statusFilter,
    lastRefresh
  } = state;
  const {
    data,
    isLoading
  } = (0, _use_fetch_slos_overview.useFetchSLOsOverview)({
    kqlQuery,
    filters,
    tagsFilter,
    statusFilter,
    lastRefresh
  });
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  const {
    data: currentSettings
  } = (0, _use_get_settings.useGetSettings)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.slo.sLOsOverview.h3.overviewLabel', {
    defaultMessage: 'Overview'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.healthy,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.healthyLabel', {
      defaultMessage: 'Healthy'
    }),
    titleColor: "success",
    isLoading: isLoading,
    query: `status : HEALTHY`,
    tooltip: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.healthyLabel.tooltip', {
      defaultMessage: 'Click to filter SLOs by Healthy status.'
    })
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.violated,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.violatedLabel', {
      defaultMessage: 'Violated'
    }),
    titleColor: "danger",
    query: `status : VIOLATED`,
    isLoading: isLoading,
    tooltip: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.violatedLabel.tooltip', {
      defaultMessage: 'Click to filter SLOs by Violated status.'
    })
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.noData,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.noDataLabel', {
      defaultMessage: 'No data'
    }),
    titleColor: "subdued",
    query: `status : NO_DATA`,
    isLoading: isLoading,
    tooltip: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.noDataLabel.tooltip', {
      defaultMessage: 'Click to filter SLOs by no data status.'
    })
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.degrading,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.degradingLabel', {
      defaultMessage: 'Degrading'
    }),
    query: `status : DEGRADING`,
    isLoading: isLoading,
    tooltip: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.degradingLabel.tooltip', {
      defaultMessage: 'Click to filter SLOs by Degrading status.'
    }),
    titleColor: theme.colors.textWarning
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.stale,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.staleLabel', {
      defaultMessage: 'Stale'
    }),
    titleColor: "subdued",
    isLoading: isLoading,
    query: `summaryUpdatedAt < "now-${(_currentSettings$stal = currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.staleThresholdInHours) !== null && _currentSettings$stal !== void 0 ? _currentSettings$stal : _constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS}h"`,
    tooltip: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.staleLabel.tooltip', {
      defaultMessage: 'Click to filter SLOs which have not been updated in last {value} hour. They are filtered out by default from the list. Threshold can be changed in SLO settings.',
      values: {
        value: (_currentSettings$stal2 = currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.staleThresholdInHours) !== null && _currentSettings$stal2 !== void 0 ? _currentSettings$stal2 : _constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS
      }
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_slo_overview_alerts.SLOOverviewAlerts, {
    data: data,
    isLoading: isLoading
  })));
}