"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkDeleteSlo = useBulkDeleteSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _bulk_operation = require("../context/bulk_operation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBulkDeleteSlo({
  onConfirm
} = {}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const bulkOperation = (0, _bulk_operation.useBulkOperation)();
  return (0, _reactQuery.useMutation)(['bulkDeleteSlo'], ({
    items
  }) => {
    return sloClient.fetch('POST /api/observability/slos/_bulk_delete 2023-10-31', {
      params: {
        body: {
          list: items.map(({
            id
          }) => id)
        }
      }
    });
  }, {
    onError: (error, {
      items
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.bulkDelete.errorNotification', {
          defaultMessage: 'Failed to schedule deletion of {count} SLOs',
          values: {
            count: items.length
          }
        })
      });
    },
    onSuccess: (response, {
      items
    }) => {
      bulkOperation.register({
        taskId: response.taskId,
        operation: 'delete',
        items
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.bulkDelete.successNotification', {
        defaultMessage: 'Bulk delete of {count} SLOs scheduled',
        values: {
          count: items.length
        }
      }));
      onConfirm === null || onConfirm === void 0 ? void 0 : onConfirm();
    }
  });
}