"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableDocs = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactHookForm = require("react-hook-form");
var _parse_kuery = require("../../../../../common/parse_kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTableDocs = ({
  sampleSize,
  name,
  dataView,
  range
}) => {
  var _getFieldState$error;
  const {
    getFieldState,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const errorMessages = (_getFieldState$error = getFieldState(name).error) === null || _getFieldState$error === void 0 ? void 0 : _getFieldState$error.message;
  const filter = watch(name);
  const esFilter = (0, _parse_kuery.getElasticsearchQueryOrThrow)(filter);
  const {
    data,
    loading,
    error
  } = (0, _public.useEsSearch)({
    index: !errorMessages ? dataView.getIndexPattern() : '',
    size: sampleSize,
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: range.from,
              lte: range.to
            }
          }
        }, esFilter]
      }
    }
  }, [range.from, range.to, dataView, JSON.stringify(filter), sampleSize, errorMessages], {
    name: 'slo-edit-documents-table'
  });
  return {
    data,
    loading,
    error
  };
};
exports.useTableDocs = useTableDocs;