"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloDetailsTabs = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _paths = require("../../../../common/locators/paths");
var _use_fetch_active_alerts = require("../../../hooks/use_fetch_active_alerts");
var _use_kibana = require("../../../hooks/use_kibana");
var _slo_details = require("../components/slo_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloDetailsTabs = ({
  slo,
  isAutoRefreshing,
  selectedTabId,
  setSelectedTabId
}) => {
  var _slo$remote, _slo$remote2, _slo$remote3, _ref, _slo$remote4;
  const {
    data: activeAlerts
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: slo ? [[slo.id, slo.instanceId]] : [],
    shouldRefetch: isAutoRefreshing
  });
  const {
    basePath
  } = (0, _use_kibana.useKibana)().services.http;
  const isRemote = !!(slo !== null && slo !== void 0 && slo.remote);
  const tabs = [{
    id: _slo_details.OVERVIEW_TAB_ID,
    label: _i18n.i18n.translate('xpack.slo.sloDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    isSelected: selectedTabId === _slo_details.OVERVIEW_TAB_ID,
    ...(setSelectedTabId ? {
      onClick: () => setSelectedTabId(_slo_details.OVERVIEW_TAB_ID)
    } : {
      href: slo ? `${basePath.get()}${_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName, _slo_details.OVERVIEW_TAB_ID)}` : undefined
    })
  }, {
    id: _slo_details.DEFINITION_TAB_ID,
    label: _i18n.i18n.translate('xpack.slo.sloDetails.tab.definitionLabel', {
      defaultMessage: 'Definition'
    }),
    'data-test-subj': 'definitionTab',
    isSelected: selectedTabId === _slo_details.DEFINITION_TAB_ID,
    ...(setSelectedTabId ? {
      onClick: () => setSelectedTabId(_slo_details.DEFINITION_TAB_ID)
    } : {
      href: slo ? `${basePath.get()}${_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote2 = slo.remote) === null || _slo$remote2 === void 0 ? void 0 : _slo$remote2.remoteName, _slo_details.DEFINITION_TAB_ID)}` : undefined
    })
  }, {
    id: _slo_details.HISTORY_TAB_ID,
    label: _i18n.i18n.translate('xpack.slo.sloDetails.tab.historyLabel', {
      defaultMessage: 'History'
    }),
    'data-test-subj': 'historyTab',
    isSelected: selectedTabId === _slo_details.HISTORY_TAB_ID,
    ...(setSelectedTabId ? {
      onClick: () => setSelectedTabId(_slo_details.HISTORY_TAB_ID)
    } : {
      href: slo ? `${basePath.get()}${_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote3 = slo.remote) === null || _slo$remote3 === void 0 ? void 0 : _slo$remote3.remoteName, _slo_details.HISTORY_TAB_ID)}` : undefined
    })
  }, {
    id: _slo_details.ALERTS_TAB_ID,
    label: isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.slo.sloDetails.tab.alertsDisabledTooltip', {
        defaultMessage: 'Alerts are not available for remote SLOs'
      }),
      position: "right"
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0
    }, ALERTS_LABEL)) : ALERTS_LABEL,
    'data-test-subj': 'alertsTab',
    disabled: Boolean(isRemote),
    isSelected: selectedTabId === _slo_details.ALERTS_TAB_ID,
    append: slo && !isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m"
    }, (_ref = activeAlerts && activeAlerts.get(slo)) !== null && _ref !== void 0 ? _ref : 0) : null,
    ...(setSelectedTabId ? {
      onClick: () => setSelectedTabId(_slo_details.ALERTS_TAB_ID)
    } : {
      href: slo ? `${basePath.get()}${_paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote4 = slo.remote) === null || _slo$remote4 === void 0 ? void 0 : _slo$remote4.remoteName, _slo_details.ALERTS_TAB_ID)}` : undefined
    })
  }];
  return {
    tabs
  };
};
exports.useSloDetailsTabs = useSloDetailsTabs;
const ALERTS_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.tab.alertsLabel', {
  defaultMessage: 'Alerts'
});