"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOGroupings = SLOGroupings;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _slo_grouping_value_selector = require("./slo_grouping_value_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOGroupings({
  slo
}) {
  var _slo$groupings;
  const groupings = Object.entries((_slo$groupings = slo.groupings) !== null && _slo$groupings !== void 0 ? _slo$groupings : {});
  if (!groupings.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.slo.sloDetails.groupings.title', {
    defaultMessage: 'Instance'
  })))), groupings.map(([groupingKey, groupingValue]) => {
    return /*#__PURE__*/_react.default.createElement(_slo_grouping_value_selector.SLOGroupingValueSelector, {
      key: groupingKey,
      slo: slo,
      groupingKey: groupingKey,
      value: String(groupingValue)
    });
  }));
}