"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloValueBadge = SloValueBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _use_kibana = require("../../../hooks/use_kibana");
var _slo_status_badge = require("./slo_status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloValueBadge({
  slo,
  isLoading
}) {
  const hasNoData = (slo === null || slo === void 0 ? void 0 : slo.summary.status) === 'NO_DATA';
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const badgeDisplayText = _i18n.i18n.translate('xpack.slo.sloStatusBadge.sloObjectiveValue', {
    defaultMessage: '{value} ({objective} objective)',
    values: {
      value: hasNoData ? '-' : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
      objective: (0, _numeral.default)(slo.objective.target).format(percentFormat)
    }
  });
  if (isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2,
      "data-test-subj": "loadingTitle"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, slo.summary.status === 'NO_DATA' ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.slo.sloStatusBadge.noDataTooltip', {
      defaultMessage: 'It may take some time before the data is aggregated and available.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _slo_status_badge.displayStatus[slo.summary.status].badgeColor,
    tabIndex: 0
  }, badgeDisplayText)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _slo_status_badge.displayStatus[slo.summary.status].badgeColor
  }, badgeDisplayText)));
}