"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelProcessTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_accordion = require("../detail_panel_accordion");
var _detail_panel_copy = require("../detail_panel_copy");
var _detail_panel_description_list = require("../detail_panel_description_list");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _data_or_dash = require("../../utils/data_or_dash");
var _helpers = require("./helpers");
var _styles = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Update placeholder descriptions for these tootips once UX Writer Team Defines them
const leaderDescriptionListInfo = [{
  id: 'processEntryLeader',
  title: 'Entry Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.entryLeaderTooltip', {
    defaultMessage: 'Session leader process associated with initial terminal or remote access via SSH, SSM and other remote access protocols. Entry sessions are also used to represent a service directly started by the init process. In many cases this is the same as the session_leader.'
  })
}, {
  id: 'processSessionLeader',
  title: 'Session Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.sessionLeaderTooltip', {
    defaultMessage: 'Often the same as entry_leader. When it differs, this represents a session started within another session. Some tools like tmux and screen will start a new session to obtain a new tty and/or separate their lifecycle from the entry session.'
  })
}, {
  id: 'processGroupLeader',
  title: 'Group Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.processGroupLeaderTooltip', {
    defaultMessage: 'The process group leader to the current process.'
  })
}, {
  id: 'processParent',
  title: 'Parent',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.processParentTooltip', {
    defaultMessage: 'The direct parent to the current process.'
  })
}];
const PROCESS_FIELD_PREFIX = 'process';
const LEADER_FIELD_PREFIX = [`${PROCESS_FIELD_PREFIX}.entry_leader`, `${PROCESS_FIELD_PREFIX}.session_leader`, `${PROCESS_FIELD_PREFIX}.group_leader`, `${PROCESS_FIELD_PREFIX}.parent`];

/**
 * Detail panel in the session view.
 */
const DetailPanelProcessTab = ({
  selectedProcess,
  index
}) => {
  const styles = (0, _styles.useStyles)();
  const processDetail = (0, _react.useMemo)(() => (0, _helpers.getDetailPanelProcess)(selectedProcess, index), [selectedProcess, index]);
  const renderExecs = (0, _react.useCallback)(executable => executable.map((execTuple, idx) => {
    const [exec, eventAction] = execTuple;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: `executable-${idx}`,
      css: styles.ellipsis
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default",
      css: styles.descriptionSemibold
    }, exec), eventAction && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default",
      css: styles.executableAction
    }, eventAction));
  }), [styles.descriptionSemibold, styles.ellipsis, styles.executableAction]);
  const leaderListItems = [processDetail.entryLeader, processDetail.sessionLeader, processDetail.groupLeader, processDetail.parent].map((leader, idx) => {
    const {
      id,
      start,
      end,
      exitCode,
      entryMetaType,
      interactive,
      workingDirectory,
      args,
      executable,
      pid,
      userId,
      userName,
      groupId,
      groupName,
      entryMetaSourceIp
    } = leader;
    const leaderExecutableText = (0, _helpers.getProcessExecutableCopyText)(executable);
    const listItems = [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "entity_id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entity_id: "${id}"`,
        tooltipContent: id
      }, id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "args"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.args: "${args}"`,
        tooltipContent: args
      }, args)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "executable"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.executable: "${leaderExecutableText}"`,
        tooltipContent: leaderExecutableText
      }, renderExecs(executable))
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "interactive"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.interactive: "${interactive}"`,
        tooltipContent: interactive
      }, interactive)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "working_directory"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.working_directory: "${workingDirectory}"`,
        tooltipContent: workingDirectory
      }, workingDirectory)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "pid"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.pid: "${pid}"`,
        tooltipContent: pid
      }, pid)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "start"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.start: "${start}"`,
        tooltipContent: start
      }, start)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "end"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.end: "${end}"`,
        tooltipContent: end
      }, end)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "exit_code"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.exit_code: "${exitCode}"`,
        tooltipContent: exitCode
      }, exitCode)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "user.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.user.id: "${userId}"`,
        tooltipContent: userId
      }, userId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "user.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.user.name: "${userName}"`,
        tooltipContent: userName
      }, userName)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "group.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.group.id: "${groupId}"`,
        tooltipContent: groupId
      }, groupId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "group.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.group.name: "${groupName}"`,
        tooltipContent: groupName
      }, groupName)
    }];
    // Only include entry_meta.type and entry_meta.source.ip for entry leader
    if (idx === 0) {
      listItems.push({
        title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "entry_meta.type"),
        description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
          textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entry_meta.type: "${entryMetaType}"`,
          tooltipContent: entryMetaType
        }, entryMetaType)
      }, {
        title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "entry_meta.source.ip"),
        description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
          textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entry_meta.source.ip: "${entryMetaSourceIp}"`,
          tooltipContent: entryMetaSourceIp
        }, (0, _data_or_dash.dataOrDash)(entryMetaSourceIp))
      });
    }
    return {
      ...leaderDescriptionListInfo[idx],
      name: leader.name,
      listItems
    };
  });
  const {
    id,
    start,
    end,
    executable,
    exitCode,
    pid,
    workingDirectory,
    interactive,
    userId,
    userName,
    groupId,
    groupName,
    args
  } = processDetail;
  const executableText = (0, _helpers.getProcessExecutableCopyText)(executable);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_description_list.DetailPanelDescriptionList, {
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "entity_id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.entity_id: "${id}"`,
        tooltipContent: id
      }, id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "args"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.args: "${args}"`,
        tooltipContent: args
      }, args)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "executable"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.executable: "${executableText}"`,
        tooltipContent: executableText,
        display: "block"
      }, renderExecs(executable))
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "interactive"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.interactive: "${interactive}"`,
        tooltipContent: interactive
      }, interactive)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "working_directory"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.working_directory: "${workingDirectory}"`,
        tooltipContent: workingDirectory
      }, workingDirectory)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "pid"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.pid: "${pid}"`,
        tooltipContent: pid
      }, pid)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "start"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.start: "${start}"`,
        tooltipContent: start
      }, start)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "end"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.end: "${end}"`,
        tooltipContent: end
      }, end)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "exit_code"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.exit_code: "${exitCode}"`,
        tooltipContent: exitCode
      }, exitCode)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "user.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.user.id: "${userId}"`,
        tooltipContent: userId
      }, userId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "user.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.user.name: "${userName}"`,
        tooltipContent: userName
      }, userName)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "group.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.group.id: "${groupId}"`,
        tooltipContent: groupId
      }, groupId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "group.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.group.name: "${groupName}"`,
        tooltipContent: groupName
      }, groupName)
    }]
  }), leaderListItems.map(leader => /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    key: leader.id,
    id: leader.id,
    title: leader.title,
    tooltipContent: leader.tooltipContent,
    listItems: leader.listItems,
    extraActionTitle: leader.name
  })));
};
exports.DetailPanelProcessTab = DetailPanelProcessTab;