"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelMetadataTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_accordion = require("../detail_panel_accordion");
var _detail_panel_copy = require("../detail_panel_copy");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _styles = require("./styles");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Host Panel of  session view detail panel.
 */
const DetailPanelMetadataTab = ({
  processHost,
  processContainer,
  processOrchestrator,
  processCloud
}) => {
  const stylesChild = (0, _styles.useStyles)();
  const hostData = (0, _react.useMemo)(() => (0, _helpers.getHostData)(processHost), [processHost]);
  const containerData = (0, _react.useMemo)(() => (0, _helpers.getContainerData)(processContainer), [processContainer]);
  const orchestratorData = (0, _react.useMemo)(() => (0, _helpers.getOrchestratorData)(processOrchestrator), [processOrchestrator]);
  const cloudData = (0, _react.useMemo)(() => (0, _helpers.getCloudData)(processCloud), [processCloud]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataHost",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.metadataHost', {
      defaultMessage: 'Host'
    }),
    initialIsOpen: true,
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.id: "${hostData.id}"`,
        tooltipContent: hostData.id
      }, hostData.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "hostname"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.hostname: "${hostData.hostname}"`,
        tooltipContent: hostData.hostname
      }, hostData.hostname)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "ip"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.ip: "${hostData.ip}"`,
        tooltipContent: hostData.ip
      }, hostData.ip)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "mac"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.mac: "${hostData.mac}"`,
        tooltipContent: hostData.mac
      }, hostData.mac)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.name: "${hostData.name}"`,
        tooltipContent: hostData.name
      }, hostData.name)
    }]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "plain",
    hasBorder: false,
    borderRadius: "m",
    paddingSize: "none",
    css: stylesChild.metadataHostOS
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "hostOS",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.host', {
      defaultMessage: 'OS'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "architecture"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.architecture: "${hostData.architecture}"`,
        tooltipContent: hostData.architecture
      }, hostData.architecture)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.family"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.family: "${hostData.os.family}"`,
        tooltipContent: hostData.os.family
      }, hostData.os.family)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.full"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.full: "${hostData.os.full}"`,
        tooltipContent: hostData.os.full
      }, hostData.os.full)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.kernel"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.kernel: "${hostData.os.kernel}"`,
        tooltipContent: hostData.os.kernel
      }, hostData.os.kernel)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.name: "${hostData.os.name}"`,
        tooltipContent: hostData.os.name
      }, hostData.os.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.platform"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.platform: "${hostData.os.platform}"`,
        tooltipContent: hostData.os.platform
      }, hostData.os.platform)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "os.version"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `host.os.version: "${hostData.os.version}"`,
        tooltipContent: hostData.os.version
      }, hostData.os.version)
    }]
  }))), processCloud && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataCloud",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.cloud', {
      defaultMessage: 'Cloud'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "instance.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.provider: "${cloudData.instance.name}"`,
        tooltipContent: cloudData.instance.name
      }, cloudData.instance.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "provider"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.provider: "${cloudData.provider}"`,
        tooltipContent: cloudData.provider
      }, cloudData.provider)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "region"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.region: "${cloudData.region}"`,
        tooltipContent: cloudData.region
      }, cloudData.region)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "account.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.account.id: "${cloudData.account.id}"`,
        tooltipContent: cloudData.account.id
      }, cloudData.account.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "project.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.project.id: "${cloudData.project.id}"`,
        tooltipContent: cloudData.project.id
      }, cloudData.project.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "project.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `cloud.project.name: "${cloudData.project.name}"`,
        tooltipContent: cloudData.project.name
      }, cloudData.project.name)
    }]
  })), processContainer && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataContainer",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.container', {
      defaultMessage: 'Container'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.id: "${containerData.id}"`,
        tooltipContent: containerData.id
      }, containerData.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.name: "${containerData.name}"`,
        tooltipContent: containerData.name
      }, containerData.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "image.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.name: "${containerData.image.name}"`,
        tooltipContent: containerData.image.name
      }, containerData.image.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "image.tag"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.tag: "${containerData.image.tag}"`,
        tooltipContent: containerData.image.tag
      }, containerData.image.tag)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "image.hash.all"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `container.image.hash.all: "${containerData.image.hash.all}"`,
        tooltipContent: containerData.image.hash.all
      }, containerData.image.hash.all)
    }]
  })), processOrchestrator && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    id: "metadataOrchestrator",
    title: _i18n.i18n.translate('xpack.sessionView.metadataDetailsTab.orchestrator', {
      defaultMessage: 'Orchestrator'
    }),
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "resource.ip"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.ip: "${orchestratorData.resource.ip}"`,
        tooltipContent: orchestratorData.resource.ip
      }, orchestratorData.resource.ip)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "resource.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.name: "${orchestratorData.resource.name}"`,
        tooltipContent: orchestratorData.resource.name
      }, orchestratorData.resource.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "resource.type"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.type: "${orchestratorData.resource.type}"`,
        tooltipContent: orchestratorData.resource.type
      }, orchestratorData.resource.type)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "resource.parent.type"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.resource.parent.type: "${orchestratorData.resource.parent.type}"`,
        tooltipContent: orchestratorData.resource.parent.type
      }, orchestratorData.resource.parent.type)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "namespace"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.namespace: "${orchestratorData.namespace}"`,
        tooltipContent: orchestratorData.namespace
      }, orchestratorData.namespace)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "cluster.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.cluster.id: "${orchestratorData.cluster.id}"`,
        tooltipContent: orchestratorData.cluster.id
      }, orchestratorData.cluster.id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, null, "cluster.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `orchestrator.cluster.name: "${orchestratorData.cluster.name}"`,
        tooltipContent: orchestratorData.cluster.name
      }, orchestratorData.cluster.name)
    }]
  })));
};
exports.DetailPanelMetadataTab = DetailPanelMetadataTab;