"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexAliasesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexAliasesFlyout = ({
  indexName,
  aliases,
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const aliasItems = aliases.map(alias => ({
    name: alias
  }));
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesFlyout.table.nameColumn.header', {
      defaultMessage: 'Alias Name'
    }),
    'data-test-subj': 'aliasNameCell',
    truncateText: false,
    width: '100%'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesFlyout.title",
    defaultMessage: "{indexName} Aliases",
    values: {
      indexName
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: aliasItems,
    columns: columns
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClose,
    "data-test-subj": "close-index-aliases-flyout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesFlyout.closeLabel",
    defaultMessage: "Close"
  }))))));
};
exports.IndexAliasesFlyout = IndexAliasesFlyout;