"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticManagedConnectorsEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _constants = require("@kbn/deeplinks-search/constants");
var _searchConnectors = require("@kbn/search-connectors");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector_types = require("../../hooks/api/use_connector_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticManagedConnectorsEmptyPrompt = () => {
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const connectorExamples = connectorTypes.filter(connector => ['Gmail', 'Sharepoint Online', 'Jira Cloud', 'Dropbox'].includes(connector.name));
  const {
    application: {
      navigateToApp
    }
  } = (0, _use_kibana.useKibanaServices)();
  return /*#__PURE__*/_react.default.createElement(_searchSharedUi.SearchEmptyPrompt, {
    backButton: {
      label: _i18n_string.BACK_LABEL,
      onClickBack: () => navigateToApp(_constants.SERVERLESS_ES_CONNECTORS_ID)
    },
    icon: "plugs",
    title: _i18n.i18n.translate('xpack.serverlessSearch.elasticManagedConnectorEmpty.title', {
      defaultMessage: 'Elastic managed connectors'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.elasticManagedConnectorEmpty.description', {
      defaultMessage: "We're actively developing Elastic managed connectors, that won't require any self-managed infrastructure. You'll be able to handle all configuration in the UI. This will simplify syncing your data into a serverless Elasticsearch project. This new workflow will have two steps:"
    }),
    isComingSoon: true,
    comingSoonLabel: _i18n_string.COMING_SOON_LABEL,
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "stretch",
      justifyContent: "center",
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_searchConnectors.DecorativeHorizontalStepper, {
      stepCount: 2
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      direction: "row",
      gutterSize: "s"
    }, connectorExamples.map((connector, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: connector.serviceType
    }, index === Math.floor(connectorExamples.length / 2) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "documents"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.ConnectorIcon, {
      name: connector.name,
      serviceType: connector.serviceType,
      iconPath: connector.iconPath,
      showTooltip: true
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.elasticManagedConnectorEmpty.guideOneDescription', {
      defaultMessage: "Choose from over 30 third-party data sources you'd like to sync"
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "plugs"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "logoElastic"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.elasticManagedConnectorEmpty.guideThreeDescription', {
      defaultMessage: 'Enter access and connection details for your data source and run your first sync using the Kibana UI'
    }))))))))))
  });
};
exports.ElasticManagedConnectorsEmptyPrompt = ElasticManagedConnectorsEmptyPrompt;