"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorLinkElasticsearch = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../../../common/doc_links");
var _use_asset_base_path = require("../../../hooks/use_asset_base_path");
var _connection_details_panel = require("./connection_details_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorLinkElasticsearch = ({
  connectorId,
  serviceType,
  status
}) => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.link.linkToElasticTitle', {
    defaultMessage: 'Link your connector to Elasticsearch'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.linkToElasticDescription', {
    defaultMessage: 'You need to run the connector code on your own infrastructure and link it to your Elasticsearch instance. You have two options:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorLinkElasticsearchRunWithDockerButton",
    iconType: `${assetBasePath}/docker.svg`,
    href: _doc_links.docLinks.connectorsRunWithDocker,
    target: "_blank",
    fill: true
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.runWithDockerLink', {
    defaultMessage: 'Run with Docker'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorLinkElasticsearchRunFromSourceButton",
    iconType: `${assetBasePath}/github_white.svg`,
    href: _doc_links.docLinks.connectorsRunFromSource,
    target: "_blank",
    fill: true
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.runFromSourceLink', {
    defaultMessage: 'Run from source'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), Boolean(serviceType) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_connection_details_panel.ConnectionDetails, {
    connectorId: connectorId,
    serviceType: serviceType,
    status: status
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.pleaseSelectServiceType', {
      defaultMessage: 'Please select a connector type.'
    }),
    color: "warning",
    iconType: "info"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), Boolean(serviceType) && (status === _searchConnectors.ConnectorStatus.CREATED || status === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.waitingForConnection', {
      defaultMessage: 'Waiting for connection'
    }),
    color: "warning",
    iconType: "info"
  })) : null));
};
exports.ConnectorLinkElasticsearch = ConnectorLinkElasticsearch;