"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateExceptionListItemResponse = exports.CreateExceptionListItemRequestBody = exports.CreateExceptionListItemCommentArray = exports.CreateExceptionListItemComment = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _exception_list_common = require("../model/exception_list_common.gen");
var _exception_list_item_entry = require("../model/exception_list_item_entry.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Create exception list item API endpoint
 *   version: 2023-10-31
 */

const CreateExceptionListItemComment = exports.CreateExceptionListItemComment = _zod.z.object({
  comment: _primitives.NonEmptyString
});
const CreateExceptionListItemCommentArray = exports.CreateExceptionListItemCommentArray = _zod.z.array(CreateExceptionListItemComment);
const CreateExceptionListItemRequestBody = exports.CreateExceptionListItemRequestBody = _zod.z.object({
  item_id: _exception_list_common.ExceptionListItemHumanId.optional(),
  list_id: _exception_list_common.ExceptionListHumanId,
  type: _exception_list_common.ExceptionListItemType,
  name: _exception_list_common.ExceptionListItemName,
  description: _exception_list_common.ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray,
  namespace_type: _exception_list_common.ExceptionNamespaceType.optional().default('single'),
  os_types: _exception_list_common.ExceptionListItemOsTypeArray.optional().default([]),
  tags: _exception_list_common.ExceptionListItemTags.optional().default([]),
  meta: _exception_list_common.ExceptionListItemMeta.optional(),
  expire_time: _exception_list_common.ExceptionListItemExpireTime.optional(),
  comments: CreateExceptionListItemCommentArray.optional().default([])
});
const CreateExceptionListItemResponse = exports.CreateExceptionListItemResponse = _exception_list_common.ExceptionListItem;