"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countUnassignedNotesLinkedToDocument = void 0;
var _esQuery = require("@kbn/es-query");
var _saved_object_mappings = require("../../saved_object_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Count notes that are not associated with the timeline & are linked to given document
 */
const countUnassignedNotesLinkedToDocument = async (savedObjectsClient, documentId) => {
  const notesCount = await savedObjectsClient.find({
    type: _saved_object_mappings.noteSavedObjectType,
    hasReference: {
      type: _saved_object_mappings.timelineSavedObjectType,
      id: ''
    },
    filter: _esQuery.nodeBuilder.is(`${_saved_object_mappings.noteSavedObjectType}.attributes.eventId`, documentId)
  });
  return notesCount.total;
};
exports.countUnassignedNotesLinkedToDocument = countUnassignedNotesLinkedToDocument;