"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSplunkSeverityToElasticSeverity = exports.getElasticSeverityFromOriginalRule = exports.getElasticRiskScoreFromOriginalRule = exports.getElasticRiskScoreFromElasticSeverity = void 0;
var _constants = require("../../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapSplunkSeverityToElasticSeverity = splunkSeverity => {
  if (!splunkSeverity) {
    return _constants.DEFAULT_TRANSLATION_SEVERITY;
  }
  return _constants.SPLUNK_ELASTIC_ALERT_SEVERITY_MAP[splunkSeverity] || _constants.DEFAULT_TRANSLATION_SEVERITY;
};
exports.mapSplunkSeverityToElasticSeverity = mapSplunkSeverityToElasticSeverity;
const getElasticSeverityFromOriginalRule = originalRule => {
  return originalRule.query_language === 'spl' || originalRule.vendor === 'splunk' ? mapSplunkSeverityToElasticSeverity(originalRule.severity) : _constants.DEFAULT_TRANSLATION_SEVERITY;
};
exports.getElasticSeverityFromOriginalRule = getElasticSeverityFromOriginalRule;
const getElasticRiskScoreFromElasticSeverity = elasticSeverity => {
  return _constants.ELASTIC_SEVERITY_TO_RISK_SCORE_MAP[elasticSeverity];
};
exports.getElasticRiskScoreFromElasticSeverity = getElasticRiskScoreFromElasticSeverity;
const getElasticRiskScoreFromOriginalRule = originalRule => {
  if (originalRule.vendor === 'splunk') {
    const elasticSeverity = getElasticSeverityFromOriginalRule(originalRule);
    return getElasticRiskScoreFromElasticSeverity(elasticSeverity);
  }
  return _constants.ELASTIC_SEVERITY_TO_RISK_SCORE_MAP[_constants.DEFAULT_TRANSLATION_SEVERITY];
};
exports.getElasticRiskScoreFromOriginalRule = getElasticRiskScoreFromOriginalRule;