"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemMigrationAuditEventType = exports.SiemMigrationsAuditActions = exports.SiemMigrationAuditLogger = exports.AUDIT_TYPE = exports.AUDIT_OUTCOME = exports.AUDIT_CATEGORY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SiemMigrationsAuditActions = exports.SiemMigrationsAuditActions = /*#__PURE__*/function (SiemMigrationsAuditActions) {
  SiemMigrationsAuditActions["SIEM_MIGRATION_CREATED"] = "siem_migration_created";
  SiemMigrationsAuditActions["SIEM_MIGRATION_UPDATED"] = "siem_migration_updated";
  SiemMigrationsAuditActions["SIEM_MIGRATION_RETRIEVED"] = "siem_migration_retrieved";
  SiemMigrationsAuditActions["SIEM_MIGRATION_DELETED"] = "siem_migration_deleted";
  SiemMigrationsAuditActions["SIEM_MIGRATION_ADDED_RULES"] = "siem_migration_added_rules";
  SiemMigrationsAuditActions["SIEM_MIGRATION_RETRIEVED_RULES"] = "siem_migration_retrieved_rules";
  SiemMigrationsAuditActions["SIEM_MIGRATION_UPLOADED_RESOURCES"] = "siem_migration_uploaded_resources";
  SiemMigrationsAuditActions["SIEM_MIGRATION_RETRIEVED_RESOURCES"] = "siem_migration_retrieved_resources";
  SiemMigrationsAuditActions["SIEM_MIGRATION_STARTED"] = "siem_migration_started";
  SiemMigrationsAuditActions["SIEM_MIGRATION_STOPPED"] = "siem_migration_stopped";
  SiemMigrationsAuditActions["SIEM_MIGRATION_UPDATED_RULE"] = "siem_migration_updated_rule";
  SiemMigrationsAuditActions["SIEM_MIGRATION_INSTALLED_RULES"] = "siem_migration_installed_rules";
  SiemMigrationsAuditActions["SIEM_MIGRATION_RETRIEVED_INTEGRATIONS_STATS"] = "siem_migration_retrieved_integrations_stats";
  return SiemMigrationsAuditActions;
}({});
let AUDIT_TYPE = exports.AUDIT_TYPE = /*#__PURE__*/function (AUDIT_TYPE) {
  AUDIT_TYPE["CHANGE"] = "change";
  AUDIT_TYPE["START"] = "start";
  AUDIT_TYPE["END"] = "end";
  AUDIT_TYPE["ACCESS"] = "access";
  AUDIT_TYPE["CREATION"] = "creation";
  return AUDIT_TYPE;
}({});
let AUDIT_CATEGORY = exports.AUDIT_CATEGORY = /*#__PURE__*/function (AUDIT_CATEGORY) {
  AUDIT_CATEGORY["API"] = "api";
  AUDIT_CATEGORY["AUTHENTICATION"] = "authentication";
  AUDIT_CATEGORY["DATABASE"] = "database";
  AUDIT_CATEGORY["WEB"] = "web";
  return AUDIT_CATEGORY;
}({});
let AUDIT_OUTCOME = exports.AUDIT_OUTCOME = /*#__PURE__*/function (AUDIT_OUTCOME) {
  AUDIT_OUTCOME["FAILURE"] = "failure";
  AUDIT_OUTCOME["SUCCESS"] = "success";
  AUDIT_OUTCOME["UNKNOWN"] = "unknown";
  return AUDIT_OUTCOME;
}({});
const siemMigrationAuditEventType = exports.siemMigrationAuditEventType = {
  [SiemMigrationsAuditActions.SIEM_MIGRATION_CREATED]: AUDIT_TYPE.CREATION,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_UPDATED]: AUDIT_TYPE.CHANGE,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED]: AUDIT_TYPE.ACCESS,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_UPLOADED_RESOURCES]: AUDIT_TYPE.CREATION,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_RESOURCES]: AUDIT_TYPE.ACCESS,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_STARTED]: AUDIT_TYPE.START,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_STOPPED]: AUDIT_TYPE.END,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_UPDATED_RULE]: AUDIT_TYPE.CHANGE,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_INSTALLED_RULES]: AUDIT_TYPE.CREATION,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_ADDED_RULES]: AUDIT_TYPE.CREATION,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_RULES]: AUDIT_TYPE.ACCESS,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_DELETED]: AUDIT_TYPE.CHANGE,
  [SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_INTEGRATIONS_STATS]: AUDIT_TYPE.ACCESS
};
class SiemMigrationAuditLogger {
  constructor(securitySolutionContextPromise) {
    (0, _defineProperty2.default)(this, "auditLogger", null);
    (0, _defineProperty2.default)(this, "setAuditLogger", async () => {
      if (this.auditLogger === null) {
        const securitySolutionContext = await this.securitySolutionContextPromise;
        this.auditLogger = securitySolutionContext.getAuditLogger();
      }
      return !!this.auditLogger;
    });
    (0, _defineProperty2.default)(this, "logEvent", ({
      action,
      message,
      error
    }) => {
      var _this$auditLogger;
      const type = siemMigrationAuditEventType[action];
      (_this$auditLogger = this.auditLogger) === null || _this$auditLogger === void 0 ? void 0 : _this$auditLogger.log({
        message,
        event: {
          action,
          category: [AUDIT_CATEGORY.DATABASE],
          type: type ? [type] : undefined,
          outcome: error ? AUDIT_OUTCOME.FAILURE : AUDIT_OUTCOME.SUCCESS
        },
        error: error && {
          code: error.name,
          message: error.message
        }
      });
    });
    this.securitySolutionContextPromise = securitySolutionContextPromise;
  }
  async log(event) {
    const auditLoggerSet = await this.setAuditLogger();
    if (!auditLoggerSet) {
      // Audit logger is not available
      return;
    }
    if (Array.isArray(event)) {
      event.forEach(e => this.logEvent(e));
    } else {
      this.logEvent(event);
    }
  }
  async logCreateMigration(params = {}) {
    const {
      error
    } = params;
    const message = `User created a new SIEM migration`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_CREATED,
      message,
      error
    });
  }
  async logUpdateMigration(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User updated the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_UPDATED,
      message,
      error
    });
  }
  async logGetMigration(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User retrieved the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED,
      message,
      error
    });
  }
  async logDeleteMigration(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User deleted the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_DELETED,
      message,
      error
    });
  }
  async logGetMigrationRules(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User retrieved rules for SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_RULES,
      message,
      error
    });
  }
  async logAddRules(params) {
    const {
      migrationId,
      error,
      count
    } = params;
    const message = `User added ${count !== null && count !== void 0 ? count : ''} rules to the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_ADDED_RULES,
      message,
      error
    });
  }
  async logUploadResources(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User uploaded resources to the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_UPLOADED_RESOURCES,
      message,
      error
    });
  }
  async logGetResources(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User retrieved resources from the SIEM migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_RESOURCES,
      message,
      error
    });
  }
  async logStart(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User stopped the SIEM rules migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_STARTED,
      message,
      error
    });
  }
  async logStop(params) {
    const {
      migrationId,
      error
    } = params;
    const message = `User stopped the SIEM rules migration with [id=${migrationId}]`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_STOPPED,
      message,
      error
    });
  }
  async logUpdateRules(params) {
    const {
      ids,
      migrationId,
      error
    } = params;
    const events = ids.map(id => {
      const message = `User updated a translated rule through SIEM migration with [id=${id}, migration_id=${migrationId}]`;
      return {
        action: SiemMigrationsAuditActions.SIEM_MIGRATION_UPDATED_RULE,
        message,
        error
      };
    });
    return this.log(events);
  }
  async logInstallRules(params) {
    const {
      ids,
      migrationId,
      error
    } = params;
    const action = SiemMigrationsAuditActions.SIEM_MIGRATION_INSTALLED_RULES;
    const events = [];
    if (ids) {
      ids.forEach(id => {
        const message = `User installed a translated rule through SIEM migration with [id=${id}, migration_id=${migrationId}]`;
        events.push({
          action,
          message,
          error
        });
      });
    } else {
      const message = `User installed all installable translated rules through SIEM migration with [migration_id=${migrationId}]`;
      events.push({
        action,
        message,
        error
      });
    }
    return this.log(events);
  }
  async logGetAllIntegrationsStats({
    error
  } = {}) {
    const message = `User retrieved all integrations stats for SIEM rule migrations`;
    return this.log({
      action: SiemMigrationsAuditActions.SIEM_MIGRATION_RETRIEVED_INTEGRATIONS_STATS,
      error,
      message
    });
  }
}
exports.SiemMigrationAuditLogger = SiemMigrationAuditLogger;