"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReadPrivilegeUserMonitoringPrivileges = void 0;
var _utils = require("../../../../common/entity_analytics/privilege_monitoring/utils");
var _check_and_format_privileges = require("../utils/check_and_format_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReadPrivilegeUserMonitoringPrivileges = async (request, security, namespace) => {
  return (0, _check_and_format_privileges.checkAndFormatPrivileges)({
    request,
    security,
    privilegesToCheck: {
      elasticsearch: {
        cluster: [],
        index: (0, _utils.getPrivilegeUserMonitoringRequiredEsIndexPrivileges)(namespace)
      }
    }
  });
};
exports.getReadPrivilegeUserMonitoringPrivileges = getReadPrivilegeUserMonitoringPrivileges;