"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createThreatSignal = void 0;
var _constants = require("../../../../../../common/constants");
var _build_threat_mapping_filter = require("./build_threat_mapping_filter");
var _get_filter = require("../../utils/get_filter");
var _search_after_bulk_create = require("../../utils/search_after_bulk_create");
var _reason_formatters = require("../../utils/reason_formatters");
var _search_after_bulk_create_suppressed_alerts = require("../../utils/search_after_bulk_create_suppressed_alerts");
var _build_threat_enrichment = require("./build_threat_enrichment");
var _get_is_alert_suppression_active = require("../../utils/get_is_alert_suppression_active");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createThreatSignal = async ({
  sharedParams,
  currentResult,
  currentThreatList,
  eventsTelemetry,
  filters,
  services,
  wrapSuppressedHits,
  threatFilters,
  threatPitId,
  reassignThreatPitId,
  allowedFieldsForTermsQuery,
  inputIndexFields,
  threatIndexFields,
  sortOrder = 'desc',
  isAlertSuppressionActive
}) => {
  var _sharedParams$complet, _threatFilter$query;
  const {
    exceptionFilter,
    inputIndex,
    ruleExecutionLogger,
    completeRule: {
      ruleParams: {
        language,
        query,
        savedId,
        threatMapping,
        type
      }
    }
  } = sharedParams;
  const threatIndicatorPath = (_sharedParams$complet = sharedParams.completeRule.ruleParams.threatIndicatorPath) !== null && _sharedParams$complet !== void 0 ? _sharedParams$complet : _constants.DEFAULT_INDICATOR_SOURCE_PATH;
  const threatFilter = (0, _build_threat_mapping_filter.buildThreatMappingFilter)({
    threatMapping,
    threatList: currentThreatList,
    entryKey: 'value',
    allowedFieldsForTermsQuery
  });
  if (!threatFilter.query || ((_threatFilter$query = threatFilter.query) === null || _threatFilter$query === void 0 ? void 0 : _threatFilter$query.bool.should.length) === 0) {
    // empty threat list and we do not want to return everything as being
    // a hit so opt to return the existing result.
    ruleExecutionLogger.debug('Indicator items are empty after filtering for missing data, returning without attempting a match');
    return currentResult;
  } else {
    var _threatFilter$query2, _threatFilter$query3;
    const esFilter = await (0, _get_filter.getFilter)({
      type,
      filters: [...filters, threatFilter],
      language,
      query,
      savedId,
      services,
      index: inputIndex,
      exceptionFilter,
      fields: inputIndexFields,
      loadFields: true
    });
    ruleExecutionLogger.debug(`${(_threatFilter$query2 = threatFilter.query) === null || _threatFilter$query2 === void 0 ? void 0 : _threatFilter$query2.bool.should.length} indicator items are being checked for existence of matches`);
    const threatEnrichment = (0, _build_threat_enrichment.buildThreatEnrichment)({
      sharedParams,
      services,
      threatFilters,
      threatIndicatorPath,
      pitId: threatPitId,
      reassignPitId: reassignThreatPitId,
      threatIndexFields
    });
    let result;
    const searchAfterBulkCreateParams = {
      sharedParams,
      buildReasonMessage: _reason_formatters.buildReasonMessageForThreatMatchAlert,
      enrichment: threatEnrichment,
      eventsTelemetry,
      filter: esFilter,
      services,
      sortOrder,
      trackTotalHits: false
    };
    if (isAlertSuppressionActive && (0, _get_is_alert_suppression_active.alertSuppressionTypeGuard)(sharedParams.completeRule.ruleParams.alertSuppression)) {
      result = await (0, _search_after_bulk_create_suppressed_alerts.searchAfterAndBulkCreateSuppressedAlerts)({
        ...searchAfterBulkCreateParams,
        wrapSuppressedHits,
        alertSuppression: sharedParams.completeRule.ruleParams.alertSuppression
      });
    } else {
      result = await (0, _search_after_bulk_create.searchAfterAndBulkCreate)(searchAfterBulkCreateParams);
    }
    ruleExecutionLogger.debug(`${(_threatFilter$query3 = threatFilter.query) === null || _threatFilter$query3 === void 0 ? void 0 : _threatFilter$query3.bool.should.length} items have completed match checks and the total times to search were ${result.searchAfterTimes.length !== 0 ? result.searchAfterTimes : '(unknown) '}ms`);
    return result;
  }
};
exports.createThreatSignal = createThreatSignal;