"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueFromRuleTriad = exports.getValueFromMergedVersion = void 0;
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _apply_rule_defaults = require("../../../rule_management/logic/detection_rules_client/mergers/apply_rule_defaults");
var _diffable_rule_fields_mappings = require("./diffable_rule_fields_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_DEFAULTS_FIELDS_SET = new Set(Object.keys(_apply_rule_defaults.RULE_DEFAULTS));
const getValueFromMergedVersion = ({
  fieldName,
  upgradeableRule,
  fieldUpgradeSpecifier,
  ruleFieldsDiff,
  onConflict
}) => {
  const ruleId = upgradeableRule.target.rule_id;
  const diffableRuleFieldName = (0, _diffable_rule_fields_mappings.mapRuleFieldToDiffableRuleField)({
    ruleType: upgradeableRule.target.type,
    fieldName
  });
  if (fieldUpgradeSpecifier.pick_version === 'MERGED') {
    const ruleFieldDiff = ruleFieldsDiff[diffableRuleFieldName];
    if (ruleFieldDiff && onConflict === _detection_engine.UpgradeConflictResolutionEnum.UPGRADE_SOLVABLE ? ruleFieldDiff.conflict !== 'NONE' && ruleFieldDiff.conflict !== 'SOLVABLE' : ruleFieldDiff.conflict !== 'NONE') {
      throw new Error(`Automatic merge calculation for field '${diffableRuleFieldName}' in rule of rule_id ${ruleId} resulted in a conflict. Please resolve the conflict manually or choose another value for 'pick_version'.`);
    }
    const mergedVersion = ruleFieldDiff.merged_version;
    return (0, _diffable_rule_fields_mappings.mapDiffableRuleFieldValueToRuleSchemaFormat)(fieldName, mergedVersion);
  }
};
exports.getValueFromMergedVersion = getValueFromMergedVersion;
const getValueFromRuleTriad = ({
  fieldName,
  upgradeableRule,
  fieldUpgradeSpecifier
}) => {
  const ruleId = upgradeableRule.target.rule_id;
  const diffableRuleFieldName = (0, _diffable_rule_fields_mappings.mapRuleFieldToDiffableRuleField)({
    ruleType: upgradeableRule.target.type,
    fieldName
  });
  const pickVersion = fieldUpgradeSpecifier.pick_version.toLowerCase();

  // By this point, can be only 'base', 'current' or 'target'
  const ruleVersion = upgradeableRule[pickVersion];
  if (!ruleVersion) {
    // Current and target versions should always be present
    // but base version might not; throw if version is missing.
    throw new Error(`Missing '${pickVersion}' version for field '${diffableRuleFieldName}' in rule ${ruleId}`);
  }

  // No need for conversions in the field names here since the rule versions in
  // UpgradableRule have the values in the 'non-grouped' PrebuiltRuleAsset schema format.
  const nonResolvedValue = ruleVersion[fieldName];

  // If there's no value for the field in the rule versions, check if the field
  // requires a default value for it. If it does, return the default value.
  if (nonResolvedValue === undefined && RULE_DEFAULTS_FIELDS_SET.has(fieldName)) {
    return _apply_rule_defaults.RULE_DEFAULTS[fieldName];
  }

  // Otherwise, return the non-resolved value, which might be undefined.
  return nonResolvedValue;
};
exports.getValueFromRuleTriad = getValueFromRuleTriad;