"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringify = void 0;
var _util = require("util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Safely traverse some content (object, array, etc) and stringify it
 * @param content
 * @param depth
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const stringify = (content, depth = 8) => {
  return (0, _util.inspect)(content, {
    depth
  });
};
exports.stringify = stringify;