"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionAgentType = void 0;
var _constants = require("../../../../../common/endpoint/constants");
var _utils = require("../../../utils");
var _errors = require("../../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the `agentType` for a given response action
 */
const getActionAgentType = async (esClient, actionId) => {
  var _response$hits, _response$hits$hits$, _response$hits$hits$$;
  const response = await esClient.search({
    index: _constants.ENDPOINT_ACTIONS_INDEX,
    query: {
      bool: {
        filter: [{
          term: {
            action_id: actionId
          }
        }]
      }
    },
    _source: ['EndpointActions.input_type'],
    size: 1
  }).catch(_utils.catchAndWrapError);
  if (!(response !== null && response !== void 0 && (_response$hits = response.hits) !== null && _response$hits !== void 0 && (_response$hits$hits$ = _response$hits.hits[0]) !== null && _response$hits$hits$ !== void 0 && (_response$hits$hits$$ = _response$hits$hits$._source) !== null && _response$hits$hits$$ !== void 0 && _response$hits$hits$$.EndpointActions.input_type)) {
    throw new _errors.NotFoundError(`Action id [${actionId}] not found`, response);
  }
  return {
    agentType: response.hits.hits[0]._source.EndpointActions.input_type
  };
};
exports.getActionAgentType = getActionAgentType;