"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldAsString = getFieldAsString;
exports.getSupportedSchemas = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This structure defines the preset supported schemas for a resolver graph. We'll probably want convert this
 * implementation to something similar to how row renderers is implemented.
 */

const getSupportedSchemas = experimentalFeatures => {
  const sentinelOneDataInAnalyzerEnabled = experimentalFeatures === null || experimentalFeatures === void 0 ? void 0 : experimentalFeatures.sentinelOneDataInAnalyzerEnabled;
  const crowdstrikeDataInAnalyzerEnabled = experimentalFeatures === null || experimentalFeatures === void 0 ? void 0 : experimentalFeatures.crowdstrikeDataInAnalyzerEnabled;
  const jamfDataInAnalyzerEnabled = experimentalFeatures === null || experimentalFeatures === void 0 ? void 0 : experimentalFeatures.jamfDataInAnalyzerEnabled;
  const supportedFileBeatDataSets = [...(sentinelOneDataInAnalyzerEnabled ? ['sentinel_one_cloud_funnel.event', 'sentinel_one.alert'] : []), ...(crowdstrikeDataInAnalyzerEnabled ? ['crowdstrike.falcon', 'crowdstrike.fdr', 'crowdstrike.alert'] : []), ...(jamfDataInAnalyzerEnabled ? ['jamf_protect.telemetry', 'jamf_protect.alerts', 'jamf_protect.web-threat-events', 'jamf_protect.web-traffic-events'] : [])];
  return [{
    name: 'endpoint',
    constraints: [{
      field: 'agent.type',
      value: 'endpoint'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      ancestry: 'process.Ext.ancestry',
      name: 'process.name',
      agentId: 'agent.id'
    }
  }, {
    name: 'winlogbeat',
    constraints: [{
      field: 'agent.type',
      value: 'winlogbeat'
    }, {
      field: 'event.module',
      value: 'sysmon'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }, {
    name: 'sysmonViaFilebeat',
    constraints: [{
      field: 'agent.type',
      value: 'filebeat'
    }, {
      field: 'event.dataset',
      value: 'windows.sysmon_operational'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }, {
    name: 'filebeat',
    constraints: [{
      field: 'agent.type',
      value: 'filebeat'
    }, {
      field: 'event.dataset',
      value: supportedFileBeatDataSets
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }];
};
exports.getSupportedSchemas = getSupportedSchemas;
function getFieldAsString(doc, field) {
  const value = _lodash.default.get(doc, field);
  if (value === undefined) {
    return undefined;
  }
  return String(value);
}