"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_COUNTS_TOOL_DESCRIPTION = exports.ALERT_COUNTS_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _helpers = require("@kbn/elastic-assistant-plugin/server/lib/langchain/helpers");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _get_alert_counts_query = require("./get_alert_counts_query");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_COUNTS_TOOL_DESCRIPTION = exports.ALERT_COUNTS_TOOL_DESCRIPTION = 'Call this for the counts of last 24 hours of open and acknowledged alerts in the environment, grouped by their severity and workflow status. The response will be JSON and from it you can summarize the information to answer the question.';
const ALERT_COUNTS_TOOL = exports.ALERT_COUNTS_TOOL = {
  id: 'alert-counts-tool',
  name: 'AlertCountsTool',
  // note: this description is overwritten when `getTool` is called
  // local definitions exist ../elastic_assistant/server/lib/prompt/tool_prompts.ts
  // local definitions can be overwritten by security-ai-prompt integration definitions
  description: ALERT_COUNTS_TOOL_DESCRIPTION,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      request,
      alertsIndexPattern
    } = params;
    return (0, _helpers.requestHasRequiredAnonymizationParams)(request) && alertsIndexPattern != null;
  },
  async getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      alertsIndexPattern,
      esClient,
      contentReferencesStore
    } = params;
    return (0, _tools.tool)(async () => {
      const query = (0, _get_alert_counts_query.getAlertsCountQuery)(alertsIndexPattern);
      const result = await esClient.search(query);
      const alertsCountReference = contentReferencesStore.add(p => (0, _elasticAssistantCommon.securityAlertsPageReference)(p.id));
      const reference = `\n${(0, _elasticAssistantCommon.contentReferenceString)(alertsCountReference)}`;
      return `${JSON.stringify(result)}${reference}`;
    }, {
      name: 'AlertCountsTool',
      description: params.description || ALERT_COUNTS_TOOL_DESCRIPTION,
      tags: ['alerts', 'alerts-count']
    });
  }
};