"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitCodeDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExitCodeDraggable = exports.ExitCodeDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameExitCode,
  eventId,
  processExitCode,
  text,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processExitCode) && (0, _helpers.isNillEmptyOrNotFinite)(endgameExitCode)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(text) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    "data-test-subj": "exit-code-draggable-text",
    grow: false,
    component: "span"
  }, text), !(0, _helpers.isNillEmptyOrNotFinite)(processExitCode) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.exit_code",
    value: `${processExitCode}`,
    fieldType: "number",
    isAggregatable: true
  })), !(0, _helpers.isNillEmptyOrNotFinite)(endgameExitCode) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "endgame.exit_code",
    value: endgameExitCode,
    fieldType: "number",
    isAggregatable: true
  })));
});
ExitCodeDraggable.displayName = 'ExitCodeDraggable';