"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _timeline = require("../timeline");
var _renderers = require("../timeline/body/renderers");
var _default_cell_renderer = require("../timeline/cell_rendering/default_cell_renderer");
var _custom_portal = require("./custom_portal");
var _use_selector = require("../../../common/hooks/use_selector");
var _selectors = require("../../../common/store/selectors");
var _index = require("./index.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMELINE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.timelinePropertiesAriaLabel', {
  defaultMessage: 'Timeline Properties'
});
/**
 * Renders the timeline modal. Internally this is using an EuiPortal.
 */
const TimelineModal = exports.TimelineModal = /*#__PURE__*/_react.default.memo(({
  timelineId,
  openToggleRef,
  visible = true
}) => {
  var _useShallowEqualSelec;
  const ref = (0, _react.useRef)(null);
  const isFullScreen = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(_selectors.inputsSelectors.timelineFullScreenSelector)) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : false;
  const styles = (0, _index.usePaneStyles)();
  const wrapperClassName = (0, _classnames.default)('timeline-portal-overlay-mask', styles, {
    'timeline-portal-overlay-mask--full-screen': isFullScreen,
    'timeline-portal-overlay-mask--hidden': !visible
  });
  const sibling = (0, _react.useMemo)(() => !visible ? ref === null || ref === void 0 ? void 0 : ref.current : null, [visible]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "timeline-portal-ref",
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_custom_portal.CustomEuiPortal, {
    sibling: sibling
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "timeline-portal-overlay-mask",
    className: wrapperClassName
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-label": TIMELINE_DESCRIPTION,
    "data-test-subj": "timeline-container",
    className: "timeline-container"
  }, /*#__PURE__*/_react.default.createElement(_timeline.StatefulTimeline, {
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    timelineId: timelineId,
    openToggleRef: openToggleRef
  })))), visible && /*#__PURE__*/_react.default.createElement(_index.OverflowHiddenGlobalStyles, null));
});
TimelineModal.displayName = 'TimelineModal';