"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsRowCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_table_context = require("../../hooks/use_table_context");
var _more_actions = require("./more_actions");
var _investigate_in_timeline = require("../../../timeline/components/investigate_in_timeline");
var _open_flyout_button = require("./open_flyout_button");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsRowCell = ({
  indicator
}) => {
  const indicatorTableContext = (0, _use_table_context.useIndicatorsTableContext)();
  const {
    setExpanded,
    expanded
  } = indicatorTableContext;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_open_flyout_button.OpenIndicatorFlyoutButton, {
    indicator: indicator,
    onOpen: setExpanded,
    isOpen: Boolean(expanded && expanded._id === indicator._id)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline.InvestigateInTimelineButtonIcon, {
    data: indicator,
    "data-test-subj": _test_ids.INVESTIGATE_IN_TIMELINE_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_more_actions.MoreActions, {
    indicator: indicator
  })));
};
exports.ActionsRowCell = ActionsRowCell;