"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsGuard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _test_ids = require("./test_ids");
var _use_integrations = require("../hooks/use_integrations");
var _empty_page = require("../modules/empty_page/empty_page");
var _use_total_count = require("../modules/indicators/hooks/use_total_count");
var _security_solution_plugin_template_wrapper = require("./security_solution_plugin_template_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders the indicators page if the user has some Threat Intelligence integrations installed or
 * the user is receiving indicators.
 * If none are received, show the EmptyPage with a link to go install integrations.
 * While the indicators call and the integrations call are loading, display a loading screen.
 */
const IntegrationsGuard = exports.IntegrationsGuard = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    isLoading: indicatorsTotalCountLoading,
    count: indicatorsTotalCount
  } = (0, _use_total_count.useIndicatorsTotalCount)();
  const {
    isLoading: integrationLoading,
    data: installedTIIntegrations
  } = (0, _use_integrations.useIntegrations)({
    enabled: !indicatorsTotalCountLoading
  });
  if (integrationLoading || indicatorsTotalCountLoading) {
    return /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, {
      isEmptyState: true,
      emptyPageBody: /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        color: "transparent"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        "data-test-subj": _test_ids.LOADING_LOGO_TEST_ID,
        logo: "logoSecurity",
        size: "xl"
      }))
    });
  }

  // show indicators page if there are indicators, or if some ti integrations have been added
  const showIndicatorsPage = indicatorsTotalCount > 0 || (installedTIIntegrations || []).length > 0;
  return showIndicatorsPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, null);
});
IntegrationsGuard.displayName = 'IntegrationsGuard';