"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _userProfileComponents = require("@kbn/user-profile-components");
var _test_ids = require("../../../../../../common/components/user_profiles/test_ids");
var _use_bulk_get_user_profiles = require("../../../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _constants = require("../../../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryTab = exports.SummaryTab = /*#__PURE__*/_react.default.memo(({
  migrationRule
}) => {
  const userProfileIds = (0, _react.useMemo)(() => {
    if (!migrationRule.comments) {
      return new Set();
    }
    return migrationRule.comments.reduce((acc, {
      created_by: createdBy
    }) => {
      if (createdBy !== _constants.SIEM_MIGRATIONS_ASSISTANT_USER) acc.add(createdBy);
      return acc;
    }, new Set());
  }, [migrationRule.comments]);
  const {
    isLoading: isLoadingUserProfiles,
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: userProfileIds
  });
  const comments = (0, _react.useMemo)(() => {
    var _migrationRule$commen;
    if (isLoadingUserProfiles) {
      return undefined;
    }
    return (_migrationRule$commen = migrationRule.comments) === null || _migrationRule$commen === void 0 ? void 0 : _migrationRule$commen.map(({
      message,
      created_at: createdAt,
      created_by: createdBy
    }) => {
      var _profile$user$full_na;
      const profile = userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles.find(({
        uid
      }) => uid === createdBy);
      const isCreatedByAssistant = createdBy === _constants.SIEM_MIGRATIONS_ASSISTANT_USER || !profile;
      const username = isCreatedByAssistant ? i18n.ASSISTANT_USERNAME : (_profile$user$full_na = profile.user.full_name) !== null && _profile$user$full_na !== void 0 ? _profile$user$full_na : profile.user.username;
      return {
        username,
        timelineAvatarAriaLabel: username,
        timelineAvatar: isCreatedByAssistant ? /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantAvatar, {
          name: "machine",
          size: "l",
          color: "subdued"
        }) : /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
          "data-test-subj": (0, _test_ids.USER_AVATAR_ITEM_TEST_ID)(username),
          user: profile === null || profile === void 0 ? void 0 : profile.user,
          avatar: profile === null || profile === void 0 ? void 0 : profile.data.avatar,
          size: 'l'
        }),
        event: migrationRule.translation_result === _constants.RuleTranslationResult.UNTRANSLATABLE ? i18n.COMMENT_EVENT_UNTRANSLATABLE : i18n.COMMENT_EVENT_TRANSLATED,
        timestamp: (0, _moment.default)(createdAt).format('ll'),
        // Date formats https://momentjs.com/docs/#/displaying/format/
        children: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
          textSize: "s"
        }, message)
      };
    });
  }, [isLoadingUserProfiles, migrationRule.comments, migrationRule.translation_result, userProfiles]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: comments,
    "aria-label": i18n.ASSISTANT_COMMENTS
  }));
});
SummaryTab.displayName = 'SummaryTab';