"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationReadyPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var _centered_loading_spinner = require("../../../../common/components/centered_loading_spinner");
var _use_kibana = require("../../../../common/lib/kibana/use_kibana");
var _use_start_migration = require("../../service/hooks/use_start_migration");
var _context = require("../data_input_flyout/context");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_missing_resources = require("../../service/hooks/use_get_missing_resources");
var _last_error = require("./last_error");
var _migration_panel_title = require("./migration_panel_title");
var _panel_text = require("../../../../common/components/panel_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationReadyPanel = exports.MigrationReadyPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats
}) => {
  var _migrationStats$last_2, _migrationStats$last_3;
  const {
    openFlyout
  } = (0, _context.useRuleMigrationDataInputContext)();
  const {
    telemetry
  } = (0, _use_kibana.useKibana)().services.siemMigrations.rules;
  const [missingResources, setMissingResources] = _react.default.useState([]);
  const {
    getMissingResources,
    isLoading
  } = (0, _use_get_missing_resources.useGetMissingResources)(setMissingResources);
  (0, _react.useEffect)(() => {
    getMissingResources(migrationStats.id);
  }, [getMissingResources, migrationStats.id]);
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout(migrationStats);
    telemetry.reportSetupMigrationOpenResources({
      migrationId: migrationStats.id,
      missingResourcesCount: missingResources.length
    });
  }, [openFlyout, migrationStats, telemetry, missingResources.length]);
  const isStopped = (0, _react.useMemo)(() => migrationStats.status === _constants.SiemMigrationTaskStatus.STOPPED, [migrationStats.status]);
  const migrationPanelDescription = (0, _react.useMemo)(() => {
    var _migrationStats$last_;
    if ((_migrationStats$last_ = migrationStats.last_execution) !== null && _migrationStats$last_ !== void 0 && _migrationStats$last_.error) {
      return i18n.RULE_MIGRATION_ERROR_DESCRIPTION(migrationStats.rules.total);
    }
    if (isStopped) {
      return i18n.RULE_MIGRATION_STOPPED_DESCRIPTION(migrationStats.rules.total);
    }
    return i18n.RULE_MIGRATION_READY_DESCRIPTION(migrationStats.rules.total);
  }, [(_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.error, migrationStats.rules.total, isStopped]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_migration_panel_title.MigrationPanelTitle, {
    migrationStats: migrationStats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    "data-test-subj": "ruleMigrationDescription",
    size: "s",
    subdued: true
  }, /*#__PURE__*/_react.default.createElement("span", null, migrationPanelDescription), !isLoading && missingResources.length > 0 && /*#__PURE__*/_react.default.createElement("span", null, " ", i18n.RULE_MIGRATION_READY_MISSING_RESOURCES))))), isLoading ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, missingResources.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "ruleMigrationMissingResourcesButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    size: "s"
  }, i18n.RULE_MIGRATION_UPLOAD_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StartTranslationButton, {
    migrationId: migrationStats.id,
    isStopped: isStopped
  })))), ((_migrationStats$last_3 = migrationStats.last_execution) === null || _migrationStats$last_3 === void 0 ? void 0 : _migrationStats$last_3.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_last_error.RuleMigrationsLastError, {
    message: migrationStats.last_execution.error
  })));
});
MigrationReadyPanel.displayName = 'MigrationReadyPanel';
const StartTranslationButton = /*#__PURE__*/_react.default.memo(({
  migrationId,
  isStopped
}) => {
  const {
    startMigration,
    isLoading
  } = (0, _use_start_migration.useStartMigration)();
  const onStartMigration = (0, _react.useCallback)(() => {
    startMigration(migrationId);
  }, [migrationId, startMigration]);
  const text = (0, _react.useMemo)(() => {
    if (isStopped) {
      return isLoading ? i18n.RULE_MIGRATION_RESUMING_TRANSLATION_BUTTON : i18n.RULE_MIGRATION_RESUME_TRANSLATION_BUTTON;
    } else {
      return isLoading ? i18n.RULE_MIGRATION_STARTING_TRANSLATION_BUTTON : i18n.RULE_MIGRATION_START_TRANSLATION_BUTTON;
    }
  }, [isStopped, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": 'startMigrationButton',
    fill: !isStopped,
    onClick: onStartMigration,
    isLoading: isLoading,
    size: "s"
  }, text);
});
StartTranslationButton.displayName = 'StartTranslationButton';