"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrationNameStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _migration_name_input = require("./migration_name_input");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_current_user_profile = require("../../../../../../../../common/components/user_profiles/use_get_current_user_profile");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMigrationNameStep = ({
  status,
  setMigrationName,
  migrationName: storedMigrationName
}) => {
  const {
    data: currentUserProfile,
    isLoading
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const migrationName = (0, _react.useMemo)(() => {
    if (storedMigrationName) {
      return storedMigrationName;
    }
    if (isLoading) {
      return undefined; // profile is still loading
    }

    // localized date and time according to the locale including seconds
    const datetime = (0, _moment.default)(Date.now()).format('ddd , ll, LTS');
    const userName = (currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user.full_name) || (currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user.username);
    if (userName) {
      return `${userName}'s migration on ${datetime}`;
    }
    return `Migration created on ${datetime}`;
  }, [storedMigrationName, currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user.username, currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user.full_name, isLoading]);
  return {
    title: i18n.MIGRATION_NAME_INPUT_TITLE,
    status,
    children: migrationName ? /*#__PURE__*/_react.default.createElement(_migration_name_input.MigrationNameInput, {
      migrationName: migrationName,
      setMigrationName: setMigrationName
    }) : null
  };
};
exports.useMigrationNameStep = useMigrationNameStep;