"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makePrettyNumber = exports.getPercChange = void 0;
var _prettyMs = _interopRequireDefault(require("pretty-ms"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPercChange = (newTime, compareTime) => {
  if (newTime != null && newTime !== 0 && compareTime != null && compareTime !== 0) {
    return `${((newTime - compareTime) / compareTime * 100).toFixed(1)}%`;
  }
  return null;
};
exports.getPercChange = getPercChange;
const makePrettyNumber = mttr => (0, _prettyMs.default)(mttr * 1000, {
  compact: true,
  verbose: false
});
exports.makePrettyNumber = makePrettyNumber;