"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _centered_loading_spinner = require("../../../common/components/centered_loading_spinner");
var _use_body_config = require("./hooks/use_body_config");
var _onboarding_card_group = require("./onboarding_card_group");
var _onboarding_card_panel = require("./onboarding_card_panel");
var _use_expanded_card = require("./hooks/use_expanded_card");
var _use_completed_cards = require("./hooks/use_completed_cards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingBody = exports.OnboardingBody = /*#__PURE__*/_react.default.memo(() => {
  const bodyConfig = (0, _use_body_config.useBodyConfig)();
  const {
    expandedCardId,
    setExpandedCardId
  } = (0, _use_expanded_card.useExpandedCard)();
  const {
    isCardComplete,
    setCardComplete,
    getCardCheckCompleteResult,
    checkCardComplete
  } = (0, _use_completed_cards.useCompletedCards)(bodyConfig);
  const createOnToggleExpanded = (0, _react.useCallback)(cardId => () => {
    if (expandedCardId === cardId) {
      setExpandedCardId(null);
    } else {
      setExpandedCardId(cardId);
      checkCardComplete(cardId);
    }
  }, [expandedCardId, setExpandedCardId, checkCardComplete]);
  const createSetCardComplete = (0, _react.useCallback)(cardId => complete => {
    setCardComplete(cardId, complete);
  }, [setCardComplete]);
  const createCheckCardComplete = (0, _react.useCallback)(cardId => () => {
    checkCardComplete(cardId);
  }, [checkCardComplete]);
  const isCardAvailable = (0, _react.useCallback)(cardId => bodyConfig.some(group => group.cards.some(card => card.id === cardId)), [bodyConfig]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, bodyConfig.map((group, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_onboarding_card_group.OnboardingCardGroup, {
    title: group.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, group.cards.map(card => {
    const {
      id,
      title,
      icon,
      iconDark,
      badge,
      Component: LazyCardComponent
    } = card;
    const cardCheckCompleteResult = getCardCheckCompleteResult(id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_onboarding_card_panel.OnboardingCardPanel, {
      id: id,
      title: title,
      icon: icon,
      iconDark: iconDark,
      badge: badge,
      checkCompleteResult: cardCheckCompleteResult,
      isExpanded: expandedCardId === id,
      isComplete: isCardComplete(id),
      onToggleExpanded: createOnToggleExpanded(id)
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
        size: "m"
      })
    }, /*#__PURE__*/_react.default.createElement(LazyCardComponent, {
      setComplete: createSetCardComplete(id),
      checkComplete: createCheckCardComplete(id),
      isCardComplete: isCardComplete,
      isCardAvailable: isCardAvailable,
      setExpandedCardId: setExpandedCardId,
      checkCompleteMetadata: cardCheckCompleteResult === null || cardCheckCompleteResult === void 0 ? void 0 : cardCheckCompleteResult.metadata
    }))));
  }))))));
});
OnboardingBody.displayName = 'OnboardingBody';