"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIntegrationsCardComplete = void 0;
var _constants = require("../../../../../../common/constants");
var _integrations_check_complete_helpers = require("../common/integrations/integrations_check_complete_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkIntegrationsCardComplete = async services => {
  const {
    isComplete,
    activePackages: activeIntegrations
  } = await (0, _integrations_check_complete_helpers.getActiveIntegrationList)(services, _constants.AI_FOR_SOC_INTEGRATIONS);
  const activeIntegrationsCount = activeIntegrations.length;
  if (!isComplete) {
    return {
      isComplete,
      metadata: {
        activeIntegrations
      }
    };
  }
  return {
    isComplete,
    completeBadgeText: (0, _integrations_check_complete_helpers.getCompleteBadgeText)(activeIntegrationsCount),
    metadata: {
      activeIntegrations
    }
  };
};
exports.checkIntegrationsCardComplete = checkIntegrationsCardComplete;